/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.gradle.service;

import com.google.common.base.Preconditions;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import net.gpedro.integrations.slack.SlackApi;
import net.gpedro.integrations.slack.SlackAttachment;
import net.gpedro.integrations.slack.SlackException;
import net.gpedro.integrations.slack.SlackMessage;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackNotificationSenderService
implements GroovyObject {
    private static final Logger LOGGER;
    public static final String SLACK__WEBHOOK__ENABLED = "SLACK_WEBHOOK_ENABLED";
    public static final String SLACK__WEBHOOK__URL = "SLACK_WEBHOOK_URL";
    private boolean enabled;
    private String webhookUrl;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public SlackNotificationSenderService(Settings settings) {
        MetaClass metaClass;
        boolean bl;
        this.enabled = bl = false;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        boolean enabled = settings.getBoolean(SLACK__WEBHOOK__ENABLED);
        String webhookUrl = settings.getString(SLACK__WEBHOOK__URL);
        if (enabled) {
            boolean bl2;
            String string;
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)webhookUrl), (Object)"a slack webhook url is required");
            this.webhookUrl = string = webhookUrl;
            this.enabled = bl2 = true;
        }
    }

    public Object send(String projectName, String msg) {
        if (this.enabled) {
            SlackApi api = new SlackApi(this.webhookUrl);
            SlackMessage message = this.createMessage(projectName, msg);
            api.call(message);
            Object var5_5 = null;
            try {
                return var5_5;
            }
            catch (SlackException ex) {
                LOGGER.error("Failed to send slack notification", (Throwable)ex);
                Object var7_7 = null;
                return var7_7;
            }
        }
        return null;
    }

    private SlackMessage createMessage(String projectName, String msg) {
        SlackMessage message = new SlackMessage(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{projectName}, new String[]{"Security issues found in *", "*"})));
        SlackAttachment slackAttachment = new SlackAttachment();
        slackAttachment.setColor("danger");
        slackAttachment.setText(msg);
        slackAttachment.setFallback(msg);
        message.addAttachments(slackAttachment);
        return message;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SlackNotificationSenderService.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        LOGGER = logger = LoggerFactory.getLogger(SlackNotificationSenderService.class);
    }
}

