/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.rules.ra.outbound;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.LocalTransaction;
import javax.resource.cci.ResultSetInfo;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.rule.builder.dialect.java.JavaDialectConfiguration;
import org.ow2.jasmine.rules.AbstractDroolsWorkingMemory;

public class DroolsWorkingMemory
extends AbstractDroolsWorkingMemory
implements Connection {
    private static Logger logger = Logger.getLogger(DroolsWorkingMemory.class.getName());
    private String location = null;

    public DroolsWorkingMemory(ClassLoader classloader) {
        super(classloader, logger);
    }

    public void start() throws Exception {
        if ("linux".equals(System.getProperty("os.name"))) {
            logger.log(Level.INFO, "Load the files contained in $JASMINE_RULES");
        } else if ("windows".equals(System.getProperty("os.name"))) {
            logger.log(Level.INFO, "Load the files contained in %JASMINE_RULES%");
        }
        if (this.location == null) {
            this.location = System.getenv("JASMINE_RULES");
            if (this.location == null) {
                logger.log(Level.SEVERE, "The environment variable JASMINE_RULES does not exist");
                throw new Exception("The environment variable JASMINE_RULES does not exist");
            }
        }
        RuleBase ruleBase = this.loadRules();
        this.createWorkingMemory(ruleBase);
    }

    public void close() throws ResourceException {
    }

    public Interaction createInteraction() throws ResourceException {
        return null;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        return null;
    }

    public ConnectionMetaData getMetaData() throws ResourceException {
        return null;
    }

    public ResultSetInfo getResultSetInfo() throws ResourceException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RuleBase loadRules() {
        ClassLoader lastClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            logger.log(Level.INFO, "Configuration of the packageBuiler for the new ruleBase...");
            PackageBuilderConfiguration pkgBuilderCfg = new PackageBuilderConfiguration(this.classLoader);
            JavaDialectConfiguration javaConf = (JavaDialectConfiguration)pkgBuilderCfg.getDialectConfiguration("java");
            javaConf.setCompiler(1);
            if (this.dumpDir != null) {
                pkgBuilderCfg.setDumpDir(this.dumpDir);
            }
            PackageBuilder packageBuilder = new PackageBuilder(pkgBuilderCfg);
            RuleBase ruleBase = RuleBaseFactory.newRuleBase();
            File directory = new File(this.location);
            if (directory.isDirectory()) {
                for (File file : directory.listFiles()) {
                    logger.log(Level.INFO, "loading " + file.getAbsolutePath() + " ...");
                    try {
                        FileReader fr = new FileReader(file.getAbsoluteFile());
                        String name = file.getName();
                        if (name.endsWith(".drl.xml")) {
                            packageBuilder.addPackageFromXml((Reader)fr);
                            logger.log(Level.INFO, file.getAbsolutePath() + " loaded");
                            continue;
                        }
                        if (name.endsWith(".drl")) {
                            File dslFile = new File(name.substring(0, name.length() - 4) + ".dsl");
                            if (dslFile.exists()) {
                                packageBuilder.addPackageFromDrl((Reader)fr, (Reader)new FileReader(dslFile));
                            } else {
                                packageBuilder.addPackageFromDrl((Reader)fr);
                            }
                            logger.log(Level.INFO, file.getAbsolutePath() + " loaded");
                            continue;
                        }
                        logger.log(Level.INFO, "extension not recognized");
                    }
                    catch (DroolsParserException e) {
                        logger.log(Level.WARNING, "Cannot add file " + file.getName() + "to the package builder", e);
                    }
                    catch (FileNotFoundException e) {
                        logger.log(Level.INFO, file.getAbsolutePath() + " ignored");
                        logger.log(Level.FINE, "Cannot access at " + file, e);
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Cannot add file " + file.getName() + "to the package builder", e);
                    }
                }
            }
            Package pack = null;
            try {
                pack = packageBuilder.getPackage();
                if (pack != null) {
                    pack.checkValidity();
                    Rule[] rules = pack.getRules();
                    if (rules.length != 0) {
                        ruleBase.addPackage(pack);
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Cannot add a package for " + pack, e);
            }
            RuleBase ruleBase2 = ruleBase;
            return ruleBase2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(lastClassLoader);
        }
    }
}

