/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.felix.utils.extender.Extension;
import org.apache.tomcat.util.descriptor.web.ServletDef;
import org.apache.tomcat.util.descriptor.web.WebXml;
import org.apache.tomcat.util.descriptor.web.WebXmlParser;
import org.apache.tomcat.util.file.Matcher;
import org.ops4j.pax.web.extender.war.internal.WebApplicationEventDispatcher;
import org.ops4j.pax.web.extender.war.internal.model.BundleWebApplication;
import org.ops4j.pax.web.service.WebContainer;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.events.WebApplicationEvent;
import org.ops4j.pax.web.service.spi.model.events.WebApplicationEventListener;
import org.ops4j.pax.web.service.spi.model.info.WebApplicationInfo;
import org.ops4j.pax.web.service.spi.model.views.ReportViewPlugin;
import org.ops4j.pax.web.service.spi.model.views.WebAppWebContainerView;
import org.ops4j.pax.web.service.spi.util.Utils;
import org.ops4j.pax.web.service.spi.util.WebContainerListener;
import org.ops4j.pax.web.service.spi.util.WebContainerManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarExtenderContext
implements WebContainerListener,
ReportViewPlugin {
    static final List<String> DEFAULT_IGNORED_LIBRARIES;
    private static final Logger LOG;
    private final BundleContext bundleContext;
    private final Bundle bundle;
    private final WebContainerManager webContainerManager;
    private final Map<Bundle, BundleWebApplication> webApplications = new HashMap<Bundle, BundleWebApplication>();
    private final Map<String, List<Bundle>> webApplicationQueue = new HashMap<String, List<Bundle>>();
    private final Lock lock = new ReentrantLock();
    private final AtomicReference<ExecutorService> pool = new AtomicReference();
    private final WebApplicationEventDispatcher webApplicationEventDispatcher;
    private final WebXml defaultWebXml;
    private final WabConflictListener wabConflictListener;
    private final List<String> jarsToSkip = new CopyOnWriteArrayList<String>();
    private final List<String> jarsToScan = new CopyOnWriteArrayList<String>();

    public WarExtenderContext(BundleContext bundleContext, ExecutorService pool) {
        this(bundleContext, pool, false);
    }

    public WarExtenderContext(BundleContext bundleContext, ExecutorService pool, boolean synchronous) {
        List scannedJarsList;
        String scannedJars;
        ArrayList<Object> skippedJarsList;
        this.bundleContext = bundleContext;
        this.bundle = bundleContext.getBundle();
        this.pool.set(pool);
        String skippedJars = bundleContext.getProperty("org.ops4j.pax.web.extender.war.jarsToSkip");
        if (skippedJars != null) {
            skippedJarsList = new ArrayList();
            for (String pattern : skippedJars.split("\\s*,\\s*")) {
                if ("default".equals(pattern)) {
                    skippedJarsList.addAll(DEFAULT_IGNORED_LIBRARIES);
                    continue;
                }
                skippedJarsList.add(pattern);
            }
        } else {
            skippedJarsList = new ArrayList<String>(DEFAULT_IGNORED_LIBRARIES);
        }
        if ((scannedJars = bundleContext.getProperty("org.ops4j.pax.web.extender.war.jarsToScan")) != null) {
            scannedJarsList = new ArrayList();
            Collections.addAll(scannedJarsList, scannedJars.split("\\s*,\\s*"));
        } else {
            scannedJarsList = Collections.emptyList();
        }
        this.webApplicationEventDispatcher = new WebApplicationEventDispatcher(bundleContext);
        this.defaultWebXml = this.findDefaultWebXml();
        this.webContainerManager = synchronous ? new WebContainerManager(bundleContext, (WebContainerListener)this) : new WebContainerManager(bundleContext, (WebContainerListener)this, "HttpService->WarExtender");
        this.webContainerManager.initialize();
        this.jarsToSkip.addAll(skippedJarsList);
        this.jarsToScan.addAll(scannedJarsList);
        this.wabConflictListener = new WabConflictListener();
        this.webApplicationEventDispatcher.getListeners().add(this.wabConflictListener);
    }

    public void shutdown() {
        ServiceReference ref;
        WebAppWebContainerView view;
        if (this.webApplicationEventDispatcher != null) {
            this.webApplicationEventDispatcher.getListeners().remove(this.wabConflictListener);
            this.webApplicationEventDispatcher.destroy();
        }
        if ((view = (WebAppWebContainerView)this.webContainerManager.containerView(this.bundle, ref = this.webContainerManager.currentWebContainerReference(), WebAppWebContainerView.class)) != null) {
            view.unregisterReportViewPlugin((ReportViewPlugin)this);
            this.webContainerManager.releaseContainer(this.bundle, ref);
        }
        this.webContainerManager.shutdown();
    }

    public ExecutorService getPool() {
        return this.pool.get();
    }

    public void setPool(ExecutorService pool) {
        this.pool.set(pool);
    }

    public List<String> getJarsToSkip() {
        return this.jarsToSkip;
    }

    public List<String> getJarsToScan() {
        return this.jarsToScan;
    }

    public void sendWebEvent(WebApplicationEvent event) {
        this.webApplicationEventDispatcher.webEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Extension createExtension(Bundle bundle, Runnable cleanup) {
        if (bundle.getState() != 32) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Ignoring a bundle {} in non-active state", (Object)bundle);
            }
            return null;
        }
        String context = Utils.getManifestHeader((Bundle)bundle, (String)"Web-ContextPath");
        if (context == null) {
            return null;
        }
        if (!context.startsWith("/") || !"/".equals(context) && context.endsWith("/")) {
            LOG.warn("{} manifest header of {} specifies invalid context path: {}. This bundle will not be processed.", new Object[]{"Web-ContextPath", bundle, context});
            return null;
        }
        BundleWebApplication webApplication = new BundleWebApplication(bundle, this.webContainerManager, this);
        webApplication.setContextPath(context);
        ServiceReference ref = this.webContainerManager.currentWebContainerReference();
        if (ref != null) {
            webApplication.webContainerAdded((ServiceReference<WebContainer>)ref);
        }
        this.lock.lock();
        try {
            this.webApplications.put(bundle, webApplication);
        }
        finally {
            this.lock.unlock();
        }
        return new WabExtension(bundle, cleanup);
    }

    public void webContainerChanged(ServiceReference<WebContainer> oldReference, ServiceReference<WebContainer> newReference) {
        if (oldReference != null) {
            this.webContainerRemoved(oldReference);
        }
        if (newReference != null) {
            this.webContainerAdded(newReference);
        }
    }

    public void bundleStopped(Bundle bundle) {
    }

    public void collectWebApplications(Set<WebApplicationInfo> webapps) {
        this.lock.lock();
        try {
            this.webApplications.values().forEach(wab -> webapps.add(wab.asWebApplicationModel()));
        }
        finally {
            this.lock.unlock();
        }
    }

    public WebApplicationInfo getWebApplication(String contextPath) {
        for (Map.Entry<Bundle, BundleWebApplication> e : this.webApplications.entrySet()) {
            if (!contextPath.equals(e.getValue().getContextPath()) || e.getValue().getDeploymentState() != BundleWebApplication.State.DEPLOYED) continue;
            return this.getWebApplication(e.getKey());
        }
        return null;
    }

    public WebApplicationInfo getWebApplication(long bundleId) {
        for (Map.Entry<Bundle, BundleWebApplication> e : this.webApplications.entrySet()) {
            if (e.getKey().getBundleId() != bundleId) continue;
            return this.getWebApplication(e.getKey());
        }
        return null;
    }

    private WebApplicationInfo getWebApplication(Bundle bundle) {
        BundleWebApplication app = this.webApplications.get(bundle);
        return app == null ? null : app.asWebApplicationModel();
    }

    public void webContainerAdded(ServiceReference<WebContainer> ref) {
        this.lock.lock();
        try {
            WebAppWebContainerView view = (WebAppWebContainerView)this.webContainerManager.containerView(this.bundle, ref, WebAppWebContainerView.class);
            if (view == null) {
                LOG.warn("Can't obtain WebAppWebContainerView from {}. No additional information will be available for web applications installed by WAR extender.", (Object)view);
            } else {
                view.registerReportViewPlugin((ReportViewPlugin)this);
            }
            this.webApplications.values().forEach(wab -> wab.webContainerAdded(ref));
        }
        finally {
            this.lock.unlock();
        }
    }

    public void webContainerRemoved(ServiceReference<WebContainer> ref) {
        this.lock.lock();
        try {
            this.webApplications.values().forEach(wab -> wab.webContainerRemoved(ref));
            WebAppWebContainerView view = (WebAppWebContainerView)this.webContainerManager.containerView(this.bundle, ref, WebAppWebContainerView.class);
            if (view != null) {
                view.unregisterReportViewPlugin((ReportViewPlugin)this);
                this.webContainerManager.releaseContainer(this.bundle, ref);
            }
        }
        finally {
            this.lock.unlock();
        }
        this.webContainerManager.releaseContainer(this.bundle, ref);
    }

    public WebXmlParser getParser() {
        WebXmlParser parser = new WebXmlParser(false, false, true);
        parser.setClassLoader(WebXmlParser.class.getClassLoader());
        return parser;
    }

    public WebXml getDefaultWebXml() {
        return this.defaultWebXml;
    }

    public WebXml findDefaultWebXml() {
        WebXml defaultWebXml = new WebXml();
        defaultWebXml.setDistributable(true);
        defaultWebXml.setOverridable(true);
        defaultWebXml.setAlwaysAddWelcomeFiles(false);
        defaultWebXml.setReplaceWelcomeFiles(true);
        try {
            URL defaultWebXmlURI = OsgiContextModel.class.getResource("/org/ops4j/pax/web/service/spi/model/default-web.xml");
            if (defaultWebXmlURI != null) {
                defaultWebXml.setURL(defaultWebXmlURI);
                this.getParser().parseWebXml(defaultWebXmlURI, defaultWebXml, false);
            }
        }
        catch (IOException e) {
            LOG.warn("Failure parsing default web.xml: {}", (Object)e.getMessage(), (Object)e);
        }
        Iterator iterator = defaultWebXml.getServlets().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry e = iterator.next();
            String name = (String)e.getKey();
            ServletDef servlet = (ServletDef)e.getValue();
            if ("default".equals(name)) {
                servlet.setServletClass(null);
                continue;
            }
            if (!"jsp".equals(name)) continue;
            if (Utils.getPaxWebJspBundle((Bundle)this.bundleContext.getBundle()) != null) {
                servlet.setServletClass("org.ops4j.pax.web.jsp.JspServlet");
                continue;
            }
            iterator.remove();
            defaultWebXml.getServletMappings().entrySet().removeIf(esm -> ((String)esm.getValue()).equals("jsp"));
            defaultWebXml.getWelcomeFiles().remove("index.jsp");
        }
        return defaultWebXml;
    }

    public WebXml findBundleWebXml(Bundle bundle) {
        WebXml mainWebXml = null;
        Enumeration descriptors = bundle.findEntries("WEB-INF", "web.xml", false);
        if (descriptors != null) {
            while (descriptors.hasMoreElements()) {
                URL next = (URL)descriptors.nextElement();
                LOG.trace("Processing {}", (Object)next);
                WebXml webXml = new WebXml();
                webXml.setURL(next);
                try {
                    if (!this.getParser().parseWebXml(next, webXml, false)) {
                        webXml = null;
                    }
                }
                catch (IOException e) {
                    LOG.warn("Failure parsing web.xml for bundle {}: {}", new Object[]{bundle, e.getMessage(), e});
                }
                if (mainWebXml == null) {
                    mainWebXml = webXml;
                    continue;
                }
                mainWebXml.merge(Collections.singleton(webXml));
            }
        }
        if (mainWebXml == null) {
            mainWebXml = new WebXml();
        }
        return mainWebXml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Long> calculateCollisionIds(String contextPath, Bundle wab) {
        HashSet<Long> ids = new HashSet<Long>();
        ids.add(wab.getBundleId());
        this.lock.lock();
        try {
            List<Bundle> awaiting = this.webApplicationQueue.get(contextPath);
            if (awaiting != null) {
                awaiting.forEach(w -> ids.add(w.getBundleId()));
            }
            this.webApplications.forEach((w, bwa) -> {
                if (contextPath.equals(bwa.getContextPath())) {
                    ids.add(w.getBundleId());
                }
            });
        }
        finally {
            this.lock.unlock();
        }
        return ids;
    }

    public boolean skipBundleScanning(Bundle scannedBundle) {
        if (scannedBundle.getBundleId() == 0L) {
            return true;
        }
        String symbolicName = scannedBundle.getSymbolicName();
        boolean skip = false;
        for (String name : this.getJarsToSkip()) {
            if (!Matcher.match((String)name, (String)symbolicName, (boolean)true)) continue;
            skip = true;
            break;
        }
        for (String name : this.getJarsToScan()) {
            if (!Matcher.match((String)name, (String)symbolicName, (boolean)true)) continue;
            skip = false;
            break;
        }
        return skip;
    }

    public boolean skipJarScanning(String jarName) {
        boolean skip = false;
        for (String name : this.getJarsToSkip()) {
            if (!name.endsWith(".jar") || !Matcher.match((String)name, (String)jarName, (boolean)true)) continue;
            skip = true;
            break;
        }
        for (String name : this.getJarsToScan()) {
            if (!name.endsWith(".jar") || !Matcher.match((String)name, (String)jarName, (boolean)true)) continue;
            skip = false;
            break;
        }
        return skip;
    }

    static {
        LOG = LoggerFactory.getLogger(WarExtenderContext.class);
        DEFAULT_IGNORED_LIBRARIES = Arrays.asList("javax.*", "jakarta.*", "org.apache.aries.*", "org.apache.aries.*.jar", "org.apache.felix.*", "org.apache.karaf.*", "org.osgi.util.*", "org.ops4j.pax.logging.*", "org.ops4j.pax.web.pax-web-api", "org.ops4j.pax.web.pax-web-spi", "org.ops4j.pax.web.pax-web-runtime", "org.ops4j.pax.web.pax-web-extender-*", "org.ops4j.pax.web.pax-web-karaf", "org.ops4j.pax.web.pax-web-jetty*", "org.ops4j.pax.web.pax-web-tomcat", "org.ops4j.pax.web.pax-web-tomcat-common", "org.ops4j.pax.web.pax-web-undertow", "org.eclipse.jdt.core.compiler.batch", "annotations-api.jar", "ant*.jar", "asm*.jar", "aspectj*.jar", "cglib*.jar", "cobertura*.jar", "org.apache.commons.*", "commons-*.jar", "dom4j-*.jar", "easymock-*.jar", "ecj-*.jar", "el-api.jar", "geronimo-spec-*.jar", "guava-*.jar", "h2*.jar", "hamcrest*.jar", "hibernate*.jar", "httpcore*.jar", "httpclient*.jar", "icu4j-*.jar", "jackson-*.jar", "jasper-el.jar", "jasper.jar", "jaspic-api.jar", "jaxb-*.jar", "jaxen-*.jar", "jdom-*.jar", "jetty-*.jar", "jmx-tools.jar", "jmx.jar", "jolokia-*.jar", "jsp-api.jar", "jstl.jar", "jta*.jar", "junit-*.jar", "junit.jar", "log4j*.jar", "mail*.jar", "objenesis-*.jar", "oraclepki.jar", "oro-*.jar", "servlet-api-*.jar", "servlet-api.jar", "slf4j*.jar", "swagger-*.jar", "taglibs-standard-spec-*.jar", "tagsoup-*.jar", "tools.jar", "websocket-api.jar", "wsdl4j*.jar", "xercesImpl.jar", "xml-apis.jar", "xmlParserAPIs-*.jar", "xmlParserAPIs.jar", "xom-*.jar");
    }

    private class DeployTask
    implements Runnable {
        private final WebApplicationEvent event;

        private DeployTask(WebApplicationEvent event) {
            this.event = event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Bundle wab = this.event.getBundle();
            String contextPath = this.event.getContextPath();
            if (this.event.getType() == WebApplicationEvent.State.FAILED && this.event.isAwaitingAllocation()) {
                LOG.info("Added {} to await-queue for {}", WarExtenderContext.this.webApplications.get(wab), (Object)contextPath);
                WarExtenderContext.this.webApplicationQueue.computeIfAbsent(contextPath, cp -> new LinkedList()).add(wab);
            }
            if (this.event.getType() == WebApplicationEvent.State.UNDEPLOYED) {
                if (WarExtenderContext.this.webApplicationQueue.containsKey(contextPath)) {
                    ((List)WarExtenderContext.this.webApplicationQueue.get(contextPath)).remove(wab);
                }
                WarExtenderContext.this.lock.lock();
                try {
                    Iterator it = ((List)WarExtenderContext.this.webApplicationQueue.get(contextPath)).iterator();
                    while (it.hasNext()) {
                        Bundle awaitingWab = (Bundle)it.next();
                        if (awaitingWab == wab) continue;
                        BundleWebApplication app = (BundleWebApplication)WarExtenderContext.this.webApplications.get(awaitingWab);
                        LOG.info("Redeploying {}, because {} is now available", (Object)app, (Object)contextPath);
                        app.deploy();
                        it.remove();
                        break;
                    }
                }
                finally {
                    WarExtenderContext.this.lock.unlock();
                }
            }
        }
    }

    private class WabConflictListener
    implements WebApplicationEventListener {
        private WabConflictListener() {
        }

        public void webEvent(WebApplicationEvent event) {
            WarExtenderContext.this.getPool().submit(new DeployTask(event));
        }
    }

    private class WabExtension
    implements Extension {
        private final Bundle bundle;
        private final Runnable cleanup;

        WabExtension(Bundle bundle, Runnable cleanup) {
            this.bundle = bundle;
            this.cleanup = cleanup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void start() throws Exception {
            String name = Thread.currentThread().getName();
            try {
                BundleWebApplication webApp;
                WarExtenderContext.this.lock.lock();
                try {
                    webApp = (BundleWebApplication)WarExtenderContext.this.webApplications.get(this.bundle);
                    if (webApp == null) {
                        return;
                    }
                }
                finally {
                    WarExtenderContext.this.lock.unlock();
                }
                long id = this.bundle.getBundleId();
                Thread.currentThread().setName(name + " (" + webApp.getContextPath() + " [" + id + "])");
                webApp.start();
            }
            finally {
                Thread.currentThread().setName(name);
            }
        }

        @Override
        public void destroy() throws Exception {
            BundleWebApplication webApp = null;
            WarExtenderContext.this.lock.lock();
            try {
                if (this.bundle.getState() == 1) {
                    webApp = (BundleWebApplication)WarExtenderContext.this.webApplications.remove(this.bundle);
                } else if (this.bundle.getState() == 16 || this.bundle.getState() == 4) {
                    webApp = (BundleWebApplication)WarExtenderContext.this.webApplications.remove(this.bundle);
                }
                if (webApp == null) {
                    return;
                }
                webApp.stop();
            }
            finally {
                if (this.cleanup != null) {
                    this.cleanup.run();
                }
                WarExtenderContext.this.lock.unlock();
            }
        }
    }
}

