/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.log4j1.internal.spi;

import org.apache.log4j.Level;
import org.ops4j.pax.logging.spi.PaxLevel;
import org.osgi.service.log.LogLevel;

public class PaxLevelImpl
implements PaxLevel {
    private Level m_delegate;

    public PaxLevelImpl(Level delegate) {
        this.m_delegate = delegate;
    }

    public boolean isGreaterOrEqual(PaxLevel r) {
        if (r instanceof PaxLevelImpl) {
            PaxLevelImpl impl = (PaxLevelImpl)r;
            return this.m_delegate.isGreaterOrEqual(impl.m_delegate);
        }
        return this.getSyslogEquivalent() <= r.getSyslogEquivalent();
    }

    public LogLevel toLevel() {
        if (this.m_delegate.isGreaterOrEqual(Level.FATAL)) {
            return LogLevel.AUDIT;
        }
        if (this.m_delegate.isGreaterOrEqual(Level.ERROR)) {
            return LogLevel.ERROR;
        }
        if (this.m_delegate.isGreaterOrEqual(Level.WARN)) {
            return LogLevel.WARN;
        }
        if (this.m_delegate.isGreaterOrEqual(Level.INFO)) {
            return LogLevel.INFO;
        }
        if (this.m_delegate.isGreaterOrEqual(Level.DEBUG)) {
            return LogLevel.DEBUG;
        }
        return LogLevel.TRACE;
    }

    public int getSyslogEquivalent() {
        return this.m_delegate.getSyslogEquivalent();
    }

    public String toString() {
        return this.m_delegate.toString();
    }
}

