/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.log4j1.internal;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.log4j.LogManager;
import org.apache.log4j.PaxLoggingConfigurator;
import org.apache.log4j.helpers.LogLog;
import org.ops4j.pax.logging.EventAdminPoster;
import org.ops4j.pax.logging.PaxContext;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingService;
import org.ops4j.pax.logging.log4j1.internal.PaxLoggerImpl;
import org.ops4j.pax.logging.spi.support.BackendSupport;
import org.ops4j.pax.logging.spi.support.ConfigurationNotifier;
import org.ops4j.pax.logging.spi.support.LogEntryImpl;
import org.ops4j.pax.logging.spi.support.LogReaderServiceImpl;
import org.ops4j.pax.logging.spi.support.OsgiUtil;
import org.ops4j.pax.logging.spi.support.PaxAppenderProxy;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.FormatterLogger;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogLevel;

public class PaxLoggingServiceImpl
implements PaxLoggingService,
ServiceFactory<Object> {
    private final BundleContext m_bundleContext;
    private volatile ReadWriteLock m_configLock;
    private final boolean locking = true;
    private final LogReaderServiceImpl m_logReader;
    private final PaxContext m_context;
    private final EventAdminPoster m_eventAdmin;
    private final ConfigurationNotifier m_configNotifier;
    private final LogLevel m_r7LogLevel = LogLevel.DEBUG;
    private final AtomicBoolean emptyConfiguration = new AtomicBoolean(false);
    private Dictionary<String, String> defaultConfiguration = null;

    public PaxLoggingServiceImpl(BundleContext context, LogReaderServiceImpl logReader, EventAdminPoster eventAdmin, ConfigurationNotifier configNotifier) {
        if (context == null) {
            throw new IllegalArgumentException("bundleContext cannot be null");
        }
        this.m_bundleContext = context;
        if (logReader == null) {
            throw new IllegalArgumentException("logReader cannot be null");
        }
        this.m_logReader = logReader;
        if (eventAdmin == null) {
            throw new IllegalArgumentException("eventAdmin cannot be null");
        }
        this.m_eventAdmin = eventAdmin;
        this.m_configNotifier = configNotifier;
        this.m_context = new PaxContext();
        String useLocks = OsgiUtil.systemOrContextProperty(context, "org.ops4j.pax.logging.useLocks");
        if (!"false".equalsIgnoreCase(useLocks)) {
            this.m_configLock = new ReentrantReadWriteLock();
        }
    }

    protected void shutdown() {
        LogManager.resetConfiguration();
    }

    void lock(boolean useWriteLock) {
        ReadWriteLock lock = this.m_configLock;
        if (lock != null) {
            if (useWriteLock) {
                lock.writeLock().lock();
            } else {
                lock.readLock().lock();
            }
        }
    }

    void unlock(boolean useWriteLock) {
        ReadWriteLock lock = this.m_configLock;
        if (lock != null) {
            if (useWriteLock) {
                lock.writeLock().unlock();
            } else {
                lock.readLock().unlock();
            }
        }
    }

    public PaxLogger getLogger(Bundle bundle, String category, String fqcn) {
        return this.getLogger(bundle, category, fqcn, false);
    }

    public LogLevel getLogLevel() {
        return this.m_r7LogLevel;
    }

    public void log(int level, String message) {
        this.logImpl(null, level, message, null, "");
    }

    public void log(int level, String message, Throwable exception) {
        this.logImpl(null, level, message, exception, "");
    }

    public void log(ServiceReference sr, int level, String message) {
        this.logImpl(sr == null ? null : sr.getBundle(), level, message, null, "");
    }

    public void log(ServiceReference sr, int level, String message, Throwable exception) {
        this.logImpl(sr == null ? null : sr.getBundle(), level, message, exception, "");
    }

    public PaxContext getPaxContext() {
        return this.m_context;
    }

    public org.osgi.service.log.Logger getLogger(String name) {
        return this.getLogger(null, name, PaxLoggerImpl.FQCN);
    }

    public org.osgi.service.log.Logger getLogger(Class<?> clazz) {
        return this.getLogger(null, clazz.getName(), PaxLoggerImpl.FQCN);
    }

    public <L extends org.osgi.service.log.Logger> L getLogger(String name, Class<L> loggerType) {
        return this.getLogger(null, name, loggerType);
    }

    public <L extends org.osgi.service.log.Logger> L getLogger(Class<?> clazz, Class<L> loggerType) {
        return this.getLogger(null, clazz.getName(), loggerType);
    }

    public <L extends org.osgi.service.log.Logger> L getLogger(Bundle bundle, String name, Class<L> loggerType) {
        return this.getLogger(bundle, name, loggerType, PaxLoggerImpl.FQCN);
    }

    private <L extends org.osgi.service.log.Logger> L getLogger(Bundle bundle, String name, Class<L> loggerType, String fqcn) {
        if (loggerType == org.osgi.service.log.Logger.class) {
            return (L)((org.osgi.service.log.Logger)loggerType.cast(this.getLogger(bundle, name, fqcn, false)));
        }
        if (loggerType == FormatterLogger.class) {
            return (L)((org.osgi.service.log.Logger)loggerType.cast(this.getLogger(bundle, name, fqcn, true)));
        }
        throw new IllegalArgumentException("Can't obtain logger with type " + loggerType);
    }

    private PaxLogger getLogger(Bundle bundle, String category, String fqcn, boolean printfFormatting) {
        org.apache.log4j.Logger log4jLogger = category == null ? org.apache.log4j.Logger.getRootLogger() : org.apache.log4j.Logger.getLogger(category);
        return new PaxLoggerImpl(bundle, log4jLogger, fqcn, this, printfFormatting);
    }

    public void setDefaultConfiguration(Dictionary<String, String> config) {
        this.defaultConfiguration = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(Dictionary<String, ?> configuration) {
        Object useLocks;
        if (configuration == null && this.defaultConfiguration == null) {
            this.configureDefaults();
            return;
        }
        if (configuration == null) {
            configuration = this.defaultConfiguration;
        }
        if (!"false".equalsIgnoreCase(String.valueOf(useLocks = configuration.get("org.ops4j.pax.logging.useLocks")))) {
            if (this.m_configLock == null) {
                this.m_configLock = new ReentrantReadWriteLock();
            }
        } else {
            this.m_configLock = null;
        }
        Properties extracted = this.extractKeys(configuration);
        this.lock(true);
        Exception problem = null;
        ClassLoader loader = null;
        List<PaxAppenderProxy> proxies = null;
        try {
            loader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            if (extracted.size() == 0) {
                this.configureDefaults();
                return;
            }
            try {
                LogManager.resetConfiguration();
                PaxLoggingConfigurator configurator = new PaxLoggingConfigurator(this.m_bundleContext);
                configurator.doConfigure(extracted, LogManager.getLoggerRepository());
                proxies = configurator.getProxies();
                this.emptyConfiguration.set(false);
            }
            catch (Exception e) {
                LogLog.error("Configuration problem: " + e.getMessage(), e);
                problem = e;
            }
        }
        finally {
            this.unlock(true);
            Thread.currentThread().setContextClassLoader(loader);
        }
        if (proxies != null) {
            for (PaxAppenderProxy proxy : proxies) {
                proxy.open();
            }
        }
        PaxLoggingServiceImpl.setLevelToJavaLogging(configuration);
        if (problem == null) {
            this.m_configNotifier.configurationDone();
        } else {
            this.m_configNotifier.configurationError(problem);
        }
    }

    private void logImpl(Bundle bundle, int level, String message, Throwable exception, String fqcn) {
        String category = BackendSupport.category(bundle);
        PaxLogger logger = this.getLogger(bundle, category, fqcn);
        if (exception != null) {
            if (level < 1) {
                logger.audit(message, (Object)exception);
            } else {
                switch (level) {
                    case 1: {
                        logger.error(message, (Object)exception);
                        break;
                    }
                    case 2: {
                        logger.warn(message, (Object)exception);
                        break;
                    }
                    case 3: {
                        logger.info(message, (Object)exception);
                        break;
                    }
                    case 4: {
                        logger.debug(message, (Object)exception);
                        break;
                    }
                    default: {
                        logger.trace(message, (Object)exception);
                        break;
                    }
                }
            }
        } else if (level < 1) {
            logger.audit(message);
        } else {
            switch (level) {
                case 1: {
                    logger.error(message);
                    break;
                }
                case 2: {
                    logger.warn(message);
                    break;
                }
                case 3: {
                    logger.info(message);
                    break;
                }
                case 4: {
                    logger.debug(message);
                    break;
                }
                default: {
                    logger.trace(message);
                }
            }
        }
    }

    void handleEvents(String name, Bundle bundle, ServiceReference<?> sr, LogLevel level, String message, Throwable exception) {
        LogEntryImpl entry = new LogEntryImpl(name, bundle, sr, level, message, exception);
        this.m_logReader.fireEvent(entry);
        if (this.m_eventAdmin != null) {
            this.m_eventAdmin.postEvent(bundle, level, (LogEntry)entry, message, exception, sr, this.getPaxContext().getContext());
        }
    }

    private Properties extractKeys(Dictionary<String, ?> configuration) {
        Properties extracted = new Properties();
        Enumeration<String> list = configuration.keys();
        while (list.hasMoreElements()) {
            String obj = list.nextElement();
            this.extractKey(extracted, configuration, obj);
        }
        return extracted;
    }

    private void extractKey(Properties extracted, Dictionary<String, ?> configuration, Object obj) {
        String key = (String)obj;
        Object value = configuration.get(obj);
        if (key.startsWith("log4j")) {
            extracted.put(key, value);
        } else if (key.startsWith("pax.") && ("pax.logging.entries.size".equals(key) || "org.ops4j.pax.logging.logReaderServiceSize".equals(key))) {
            try {
                this.m_logReader.setMaxEntries(Integer.parseInt((String)value));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void configureDefaults() {
        if (!this.emptyConfiguration.compareAndSet(false, true)) {
            this.m_configNotifier.configurationDone();
            return;
        }
        try {
            LogManager.resetConfiguration();
            String levelName = BackendSupport.defaultLogLevel(this.m_bundleContext);
            Level julLevel = BackendSupport.toJULLevel(levelName);
            org.apache.log4j.Level log4j1Level = org.apache.log4j.Level.toLevel(levelName, org.apache.log4j.Level.DEBUG);
            PaxLoggingConfigurator configurator = new PaxLoggingConfigurator(this.m_bundleContext);
            Properties defaultProperties = new Properties();
            defaultProperties.put("log4j.rootLogger", log4j1Level.toString() + ", A1");
            defaultProperties.put("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
            defaultProperties.put("log4j.appender.A1.layout", "org.apache.log4j.TTCCLayout");
            this.extractSystemProperties(defaultProperties);
            configurator.doConfigure(defaultProperties, LogManager.getLoggerRepository());
            Logger rootLogger = Logger.getLogger("");
            rootLogger.setLevel(julLevel);
            this.m_configNotifier.configurationDone();
        }
        catch (Exception e) {
            LogLog.error("Configuration problem: " + e.getMessage(), e);
            this.m_configNotifier.configurationError(e);
        }
    }

    private void extractSystemProperties(Properties output) {
        Properties properties = System.getProperties();
        for (String key : properties.stringPropertyNames()) {
            if (!key.startsWith("pax.log4j")) continue;
            String value = properties.getProperty(key);
            key = key.substring(4);
            output.put(key, value);
        }
    }

    public Object getService(final Bundle bundle, ServiceRegistration registration) {
        class ManagedPaxLoggingService
        implements PaxLoggingService {
            private final String FQCN;

            ManagedPaxLoggingService() {
                this.FQCN = ManagedPaxLoggingService.class.getName();
            }

            public void log(int level, String message) {
                PaxLoggingServiceImpl.this.logImpl(bundle, level, message, null, this.FQCN);
            }

            public void log(int level, String message, Throwable exception) {
                PaxLoggingServiceImpl.this.logImpl(bundle, level, message, exception, this.FQCN);
            }

            public void log(ServiceReference sr, int level, String message) {
                PaxLoggingServiceImpl.this.logImpl(bundle, level, message, null, this.FQCN);
            }

            public void log(ServiceReference sr, int level, String message, Throwable exception) {
                PaxLoggingServiceImpl.this.logImpl(bundle, level, message, exception, this.FQCN);
            }

            public LogLevel getLogLevel() {
                return PaxLoggingServiceImpl.this.getLogLevel();
            }

            public PaxLogger getLogger(Bundle myBundle, String category, String fqcn) {
                return PaxLoggingServiceImpl.this.getLogger(myBundle, category, fqcn);
            }

            public PaxContext getPaxContext() {
                return PaxLoggingServiceImpl.this.getPaxContext();
            }

            public org.osgi.service.log.Logger getLogger(String name) {
                return PaxLoggingServiceImpl.this.getLogger(bundle, name, PaxLoggerImpl.FQCN);
            }

            public org.osgi.service.log.Logger getLogger(Class<?> clazz) {
                return PaxLoggingServiceImpl.this.getLogger(bundle, clazz.getName(), PaxLoggerImpl.FQCN);
            }

            public <L extends org.osgi.service.log.Logger> L getLogger(String name, Class<L> loggerType) {
                return (L)PaxLoggingServiceImpl.this.getLogger(bundle, name, loggerType, PaxLoggerImpl.FQCN);
            }

            public <L extends org.osgi.service.log.Logger> L getLogger(Class<?> clazz, Class<L> loggerType) {
                return (L)PaxLoggingServiceImpl.this.getLogger(bundle, clazz.getName(), loggerType, PaxLoggerImpl.FQCN);
            }

            public <L extends org.osgi.service.log.Logger> L getLogger(Bundle bundle2, String name, Class<L> loggerType) {
                return (L)PaxLoggingServiceImpl.this.getLogger(bundle2, name, loggerType, PaxLoggerImpl.FQCN);
            }
        }
        return new ManagedPaxLoggingService();
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
    }

    private static void setLevelToJavaLogging(Dictionary<String, ?> configuration) {
        String name;
        Enumeration<String> enum_ = java.util.logging.LogManager.getLogManager().getLoggerNames();
        while (enum_.hasMoreElements()) {
            name = enum_.nextElement();
            Logger.getLogger(name).setLevel(null);
        }
        Enumeration<String> keys = configuration.keys();
        while (keys.hasMoreElements()) {
            name = keys.nextElement();
            String value = (String)configuration.get(name);
            if (name.equals("log4j.rootLogger")) {
                PaxLoggingServiceImpl.setJULLevel(Logger.getGlobal(), value);
                PaxLoggingServiceImpl.setJULLevel(Logger.getLogger(""), value);
                PaxLoggingServiceImpl.setJULLevel(Logger.getLogger("global"), value);
            }
            if (!name.startsWith("log4j.logger.")) continue;
            String packageName = name.substring("log4j.logger.".length());
            Logger logger = Logger.getLogger(packageName);
            PaxLoggingServiceImpl.setJULLevel(logger, value);
        }
    }

    private static void setJULLevel(Logger logger, String log4jLevelConfig) {
        String[] crumb = log4jLevelConfig.split("\\s*,\\s*");
        if (crumb.length > 0) {
            Level level = BackendSupport.toJULLevel(crumb[0].trim());
            logger.setLevel(level);
        }
    }
}

