/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.format;

import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.tree.Misc;
import org.openrewrite.xml.tree.Xml;

public class LineBreaksVisitor<P>
extends XmlIsoVisitor<P> {
    private final @Nullable Tree stopAfter;

    public LineBreaksVisitor() {
        this(null);
    }

    public LineBreaksVisitor(@Nullable Tree stopAfter) {
        this.stopAfter = stopAfter;
    }

    @Override
    public Xml.Comment visitComment(Xml.Comment comment, P p) {
        return this.keepMaximumLines((Xml.Comment)this.minimumLines(super.visitComment(comment, (Object)p), this.isFirstMisc(comment) ? 0 : 1), 2);
    }

    @Override
    public Xml.DocTypeDecl visitDocTypeDecl(Xml.DocTypeDecl docTypeDecl, P p) {
        return this.keepMaximumLines((Xml.DocTypeDecl)this.minimumLines(super.visitDocTypeDecl(docTypeDecl, (Object)p), this.isFirstMisc(docTypeDecl) ? 0 : 1), 1);
    }

    @Override
    public Xml.ProcessingInstruction visitProcessingInstruction(Xml.ProcessingInstruction processingInstruction, P p) {
        return this.keepMaximumLines((Xml.ProcessingInstruction)this.minimumLines(super.visitProcessingInstruction(processingInstruction, (Object)p), this.isFirstMisc(processingInstruction) ? 0 : 1), 1);
    }

    @Override
    public Xml.Prolog visitProlog(Xml.Prolog prolog, P p) {
        return super.visitProlog(prolog, (Object)p);
    }

    @Override
    public Xml.Tag visitTag(Xml.Tag tag, P p) {
        Xml.Document doc = (Xml.Document)this.getCursor().firstEnclosingOrThrow(Xml.Document.class);
        Xml.Tag t = this.keepMaximumLines((Xml.Tag)this.minimumLines(super.visitTag(tag, (Object)p), doc.getRoot().isScope(tag) && doc.getProlog().getXmlDecl() == null && doc.getProlog().getMisc().isEmpty() ? 0 : 1), 2);
        if (t.getClosing() != null && !t.getChildren().isEmpty()) {
            t = t.withClosing(this.keepMaximumLines(this.minimumLines(t.getClosing(), 1), 2));
        }
        return t;
    }

    private boolean isFirstMisc(Misc misc) {
        Xml.Document doc = (Xml.Document)this.getCursor().firstEnclosingOrThrow(Xml.Document.class);
        if (doc.getProlog().getXmlDecl() == null) {
            return !doc.getProlog().getMisc().isEmpty() && doc.getProlog().getMisc().get(0) == misc;
        }
        return misc == doc.getProlog().getXmlDecl();
    }

    private <X extends Xml> X keepMaximumLines(X tree, int max) {
        return (X)tree.withPrefix(this.keepMaximumLines(tree.getPrefix(), max));
    }

    private String keepMaximumLines(String whitespace, int max) {
        long blankLines = whitespace.chars().filter(c -> c == 10).count() - 1L;
        if (blankLines > (long)max) {
            int startWhitespaceAtIndex = 0;
            int i = 0;
            while ((long)i < blankLines - (long)max) {
                startWhitespaceAtIndex = whitespace.indexOf(10, startWhitespaceAtIndex);
                ++i;
                ++startWhitespaceAtIndex;
            }
            return whitespace.substring(--startWhitespaceAtIndex);
        }
        return whitespace;
    }

    private <X extends Xml> X minimumLines(X tree, int max) {
        return (X)tree.withPrefix(this.minimumLines(tree.getPrefix(), max));
    }

    private String minimumLines(String whitespace, int min) {
        if (min == 0) {
            return whitespace;
        }
        String minWhitespace = whitespace;
        int i = 0;
        while ((long)i < (long)min - whitespace.chars().filter(c -> c == 10).count()) {
            minWhitespace = "\n" + minWhitespace;
            ++i;
        }
        return minWhitespace;
    }

    public @Nullable Xml postVisit(Xml tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(Xml.Document.class, "stop", (Object)true);
        }
        return (Xml)super.postVisit((Tree)tree, p);
    }

    public @Nullable Xml visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (Xml)tree;
        }
        return (Xml)super.visit(tree, p);
    }
}

