/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.RemoveContentVisitor;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public final class RemoveProperty
extends Recipe {
    @Option(displayName="Property name", description="Key name of the property to remove.", example="junit.version")
    private final String propertyName;

    public String getDisplayName() {
        return "Remove Maven project property";
    }

    public String getDescription() {
        return "Removes the specified Maven project property from the pom.xml.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new RemovePropertyVisitor();
    }

    @Generated
    public RemoveProperty(String propertyName) {
        this.propertyName = propertyName;
    }

    @Generated
    public String getPropertyName() {
        return this.propertyName;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RemoveProperty(propertyName=" + this.getPropertyName() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveProperty)) {
            return false;
        }
        RemoveProperty other = (RemoveProperty)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$propertyName = this.getPropertyName();
        String other$propertyName = other.getPropertyName();
        return !(this$propertyName == null ? other$propertyName != null : !this$propertyName.equals(other$propertyName));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveProperty;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $propertyName = this.getPropertyName();
        result = result * 59 + ($propertyName == null ? 43 : $propertyName.hashCode());
        return result;
    }

    private class RemovePropertyVisitor
    extends MavenVisitor<ExecutionContext> {
        private RemovePropertyVisitor() {
        }

        public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
            if (this.isPropertyTag() && RemoveProperty.this.propertyName.equals(tag.getName())) {
                this.doAfterVisit((TreeVisitor)new RemoveContentVisitor((Content)tag, true, true));
                this.maybeUpdateModel();
            }
            return super.visitTag(tag, (Object)ctx);
        }
    }
}

