/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.search;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.table.ManagedDependencyGraph;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedManagedDependency;
import org.openrewrite.xml.tree.Xml;

public final class EffectiveManagedDependencies
extends Recipe {
    private final transient ManagedDependencyGraph dependencyGraph = new ManagedDependencyGraph(this);

    public String getDisplayName() {
        return "Effective managed dependencies";
    }

    public String getDescription() {
        return "Emit the data of binary dependency relationships.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                MavenResolutionResult mrr = this.getResolutionResult();
                EffectiveManagedDependencies.this.emitParent(mrr, ctx);
                return document;
            }
        };
    }

    private void emitParent(MavenResolutionResult mrr, ExecutionContext ctx) {
        if (mrr.getParent() != null) {
            this.dependencyGraph.insertRow(ctx, new ManagedDependencyGraph.Row(String.format("%s:%s:%s", mrr.getPom().getGroupId(), mrr.getPom().getArtifactId(), mrr.getPom().getVersion()), String.format("%s:%s:%s", mrr.getParent().getPom().getGroupId(), mrr.getParent().getPom().getArtifactId(), mrr.getParent().getPom().getVersion())));
            for (ResolvedManagedDependency managed : mrr.getPom().getDependencyManagement()) {
                this.dependencyGraph.insertRow(ctx, new ManagedDependencyGraph.Row(String.format("%s:%s:%s", mrr.getPom().getGroupId(), mrr.getPom().getArtifactId(), mrr.getPom().getVersion()), String.format("%s:%s:%s", managed.getGroupId(), managed.getArtifactId(), managed.getVersion())));
            }
        }
    }

    @Generated
    public EffectiveManagedDependencies() {
    }

    @Generated
    public ManagedDependencyGraph getDependencyGraph() {
        return this.dependencyGraph;
    }

    @NonNull
    @Generated
    public String toString() {
        return "EffectiveManagedDependencies(dependencyGraph=" + (Object)((Object)this.getDependencyGraph()) + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EffectiveManagedDependencies)) {
            return false;
        }
        EffectiveManagedDependencies other = (EffectiveManagedDependencies)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof EffectiveManagedDependencies;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

