/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.fasterxml.jackson.dataformat.xml.util.DefaultXmlPrettyPrinter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.intellij.lang.annotations.Language;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.PathUtils;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.internal.MavenXmlMapper;
import org.openrewrite.style.GeneralFormatStyle;
import org.openrewrite.style.Style;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.XmlParser;
import org.openrewrite.xml.tree.Xml;

public final class AddGradleEnterpriseMavenExtension
extends ScanningRecipe<Accumulator> {
    private static final String GRADLE_ENTERPRISE_MAVEN_EXTENSION_ARTIFACT_ID = "gradle-enterprise-maven-extension";
    private static final String EXTENSIONS_XML_PATH = ".mvn/extensions.xml";
    private static final String GRADLE_ENTERPRISE_XML_PATH = ".mvn/gradle-enterprise.xml";
    @Language(value="xml")
    private static final String EXTENSIONS_XML_FORMAT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<extensions>\n</extensions>";
    @Language(value="xml")
    private static final String ENTERPRISE_TAG_FORMAT = "<extension>\n  <groupId>com.gradle</groupId>\n  <artifactId>gradle-enterprise-maven-extension</artifactId>\n  <version>%s</version>\n</extension>";
    @Language(value="xml")
    private static final String ENTERPRISE_TAG_FORMAT_WITHOUT_VERSION = "<extension>\n  <groupId>com.gradle</groupId>\n  <artifactId>gradle-enterprise-maven-extension</artifactId>\n</extension>";
    @Option(displayName="Plugin version", description="An exact version number or node-style semver selector used to select the gradle-enterprise-maven-extension version.", example="1.x")
    @Nullable
    private final String version;
    @Option(displayName="Server URL", description="The URL of the Gradle Enterprise server.", example="https://scans.gradle.com/")
    private final String server;
    @Option(displayName="Allow untrusted server", description="When set to `true` the plugin will be configured to allow unencrypted http connections with the server. If set to `false` or omitted, the plugin will refuse to communicate without transport layer security enabled.", required=false, example="true")
    @Nullable
    private final Boolean allowUntrustedServer;
    @Option(displayName="Capture goal input files", description="When set to `true` the extension will capture additional information about the inputs to Maven goals. This increases the size of build scans, but is useful for diagnosing issues with goal caching. ", required=false, example="true")
    @Nullable
    private final Boolean captureGoalInputFiles;
    @Option(displayName="Upload in background", description="When set to `false` the extension will not upload build scan in the background. By default, build scans are uploaded in the background after the build has finished to avoid blocking the build process.", required=false, example="false")
    @Nullable
    private final Boolean uploadInBackground;
    @Option(displayName="Publish Criteria", description="When set to `always` the extension will publish build scans of every single build. This is the default behavior when omitted.When set to `failure` the extension will only publish build scans when the build fails. When set to `demand` the extension will only publish build scans when explicitly requested.", required=false, valid={"always", "failure", "demand"}, example="true")
    @Nullable
    private final PublishCriteria publishCriteria;

    public String getDisplayName() {
        return "Add Gradle Enterprise Maven Extension to maven projects";
    }

    public String getDescription() {
        return "To integrate gradle enterprise maven extension into maven projects, ensure that the `gradle-enterprise-maven-extension` is added to the `.mvn/extensions.xml` file if not already present. Additionally, configure the extension by adding the `.mvn/gradle-enterprise.xml` configuration file.";
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                String sourcePath;
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                SourceFile sourceFile = (SourceFile)tree;
                switch (sourcePath = PathUtils.separatorsToUnix((String)sourceFile.getSourcePath().toString())) {
                    case "pom.xml": {
                        acc.setMavenProject(true);
                        acc.setUseCRLFNewLines(((GeneralFormatStyle)sourceFile.getStyle(GeneralFormatStyle.class, (Style)new GeneralFormatStyle(false))).isUseCRLFNewLines());
                        break;
                    }
                    case ".mvn/extensions.xml": {
                        if (!(sourceFile instanceof Xml.Document)) {
                            throw new RuntimeException("The extensions.xml is not xml document type");
                        }
                        acc.setMatchingExtensionsXmlFile(sourceFile.getSourcePath());
                        break;
                    }
                    case ".mvn/gradle-enterprise.xml": {
                        acc.setMatchingGradleEnterpriseXmlFile(sourceFile.getSourcePath());
                        break;
                    }
                }
                return tree;
            }
        };
    }

    public Collection<? extends SourceFile> generate(Accumulator acc, ExecutionContext ctx) {
        if (!acc.isMavenProject() || acc.getMatchingGradleEnterpriseXmlFile() != null) {
            return Collections.emptyList();
        }
        ArrayList<Xml.Document> sources = new ArrayList<Xml.Document>();
        sources.add(AddGradleEnterpriseMavenExtension.createNewXml(GRADLE_ENTERPRISE_XML_PATH, this.gradleEnterpriseConfiguration(acc.isUseCRLFNewLines())));
        if (acc.getMatchingExtensionsXmlFile() == null) {
            Xml.Document extensionsXml = AddGradleEnterpriseMavenExtension.createNewXml(EXTENSIONS_XML_PATH, EXTENSIONS_XML_FORMAT);
            extensionsXml = this.addEnterpriseExtension(extensionsXml, ctx);
            sources.add(extensionsXml);
        }
        return sources;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Accumulator acc) {
        if (!acc.isMavenProject() || acc.getMatchingExtensionsXmlFile() == null) {
            return TreeVisitor.noop();
        }
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                SourceFile sourceFile = (SourceFile)tree;
                if (sourceFile.getSourcePath().equals(acc.getMatchingExtensionsXmlFile())) {
                    Xml.Document extensionsXml = (Xml.Document)sourceFile;
                    boolean hasEnterpriseExtension = AddGradleEnterpriseMavenExtension.this.findExistingEnterpriseExtension(extensionsXml);
                    if (hasEnterpriseExtension) {
                        return sourceFile;
                    }
                    return AddGradleEnterpriseMavenExtension.this.addEnterpriseExtension(extensionsXml, ctx);
                }
                return tree;
            }
        };
    }

    private String gradleEnterpriseConfiguration(boolean useCRLFNewLines) {
        BuildScanConfiguration buildScanConfiguration = this.buildScanConfiguration();
        ServerConfiguration serverConfiguration = new ServerConfiguration(this.server, this.allowUntrustedServer);
        try {
            ObjectMapper objectMapper = MavenXmlMapper.writeMapper();
            objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
            DefaultXmlPrettyPrinter pp = new DefaultXmlPrettyPrinter().withCustomNewLine(useCRLFNewLines ? "\r\n" : "\n");
            return objectMapper.writer((PrettyPrinter)pp).writeValueAsString((Object)new GradleEnterpriseConfiguration(serverConfiguration, buildScanConfiguration));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    private BuildScanConfiguration buildScanConfiguration() {
        if (this.uploadInBackground != null || this.publishCriteria != null || this.captureGoalInputFiles != null) {
            return new BuildScanConfiguration(this.uploadInBackground, this.publishCriteria != null ? this.publishCriteria.xmlName : null, this.captureGoalInputFiles != null ? new Capture(this.captureGoalInputFiles) : null);
        }
        return null;
    }

    private static Xml.Document createNewXml(String filePath, @Language(value="xml") String fileContents) {
        XmlParser parser = new XmlParser();
        Xml.Document brandNewFile = parser.parse(new String[]{fileContents}).findFirst().map(Xml.Document.class::cast).orElseThrow(() -> new IllegalArgumentException("Unable to parse XML contents"));
        return brandNewFile.withSourcePath(Paths.get(filePath, new String[0]));
    }

    private boolean findExistingEnterpriseExtension(Xml.Document extensionsXml) {
        final XPathMatcher xPathMatcher = new XPathMatcher("/extensions/extension/artifactId");
        return ((AtomicBoolean)new XmlIsoVisitor<AtomicBoolean>(){

            public Xml.Tag visitTag(Xml.Tag tag, AtomicBoolean found) {
                Optional maybeArtifactId;
                if (found.get()) {
                    return tag;
                }
                tag = super.visitTag(tag, (Object)found);
                if (xPathMatcher.matches(this.getCursor()) && (maybeArtifactId = tag.getValue()).isPresent() && ((String)maybeArtifactId.get()).equals(AddGradleEnterpriseMavenExtension.GRADLE_ENTERPRISE_MAVEN_EXTENSION_ARTIFACT_ID)) {
                    found.set(true);
                }
                return tag;
            }
        }.reduce((Tree)extensionsXml, (Object)new AtomicBoolean())).get();
    }

    private Xml.Document addEnterpriseExtension(Xml.Document extensionsXml, ExecutionContext ctx) {
        String tagSource = this.version != null ? String.format(ENTERPRISE_TAG_FORMAT, this.version) : ENTERPRISE_TAG_FORMAT_WITHOUT_VERSION;
        AddToTagVisitor addToTagVisitor = new AddToTagVisitor(extensionsXml.getRoot(), Xml.Tag.build((String)tagSource));
        return (Xml.Document)addToTagVisitor.visitNonNull((Tree)extensionsXml, (Object)ctx);
    }

    public AddGradleEnterpriseMavenExtension(@Nullable String version, String server, @Nullable Boolean allowUntrustedServer, @Nullable Boolean captureGoalInputFiles, @Nullable Boolean uploadInBackground, @Nullable PublishCriteria publishCriteria) {
        this.version = version;
        this.server = server;
        this.allowUntrustedServer = allowUntrustedServer;
        this.captureGoalInputFiles = captureGoalInputFiles;
        this.uploadInBackground = uploadInBackground;
        this.publishCriteria = publishCriteria;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    public String getServer() {
        return this.server;
    }

    @Nullable
    public Boolean getAllowUntrustedServer() {
        return this.allowUntrustedServer;
    }

    @Nullable
    public Boolean getCaptureGoalInputFiles() {
        return this.captureGoalInputFiles;
    }

    @Nullable
    public Boolean getUploadInBackground() {
        return this.uploadInBackground;
    }

    @Nullable
    public PublishCriteria getPublishCriteria() {
        return this.publishCriteria;
    }

    @NonNull
    public String toString() {
        return "AddGradleEnterpriseMavenExtension(version=" + this.getVersion() + ", server=" + this.getServer() + ", allowUntrustedServer=" + this.getAllowUntrustedServer() + ", captureGoalInputFiles=" + this.getCaptureGoalInputFiles() + ", uploadInBackground=" + this.getUploadInBackground() + ", publishCriteria=" + (Object)((Object)this.getPublishCriteria()) + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddGradleEnterpriseMavenExtension)) {
            return false;
        }
        AddGradleEnterpriseMavenExtension other = (AddGradleEnterpriseMavenExtension)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$allowUntrustedServer = this.getAllowUntrustedServer();
        Boolean other$allowUntrustedServer = other.getAllowUntrustedServer();
        if (this$allowUntrustedServer == null ? other$allowUntrustedServer != null : !((Object)this$allowUntrustedServer).equals(other$allowUntrustedServer)) {
            return false;
        }
        Boolean this$captureGoalInputFiles = this.getCaptureGoalInputFiles();
        Boolean other$captureGoalInputFiles = other.getCaptureGoalInputFiles();
        if (this$captureGoalInputFiles == null ? other$captureGoalInputFiles != null : !((Object)this$captureGoalInputFiles).equals(other$captureGoalInputFiles)) {
            return false;
        }
        Boolean this$uploadInBackground = this.getUploadInBackground();
        Boolean other$uploadInBackground = other.getUploadInBackground();
        if (this$uploadInBackground == null ? other$uploadInBackground != null : !((Object)this$uploadInBackground).equals(other$uploadInBackground)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$server = this.getServer();
        String other$server = other.getServer();
        if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
            return false;
        }
        PublishCriteria this$publishCriteria = this.getPublishCriteria();
        PublishCriteria other$publishCriteria = other.getPublishCriteria();
        return !(this$publishCriteria == null ? other$publishCriteria != null : !((Object)((Object)this$publishCriteria)).equals((Object)other$publishCriteria));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddGradleEnterpriseMavenExtension;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $allowUntrustedServer = this.getAllowUntrustedServer();
        result = result * 59 + ($allowUntrustedServer == null ? 43 : ((Object)$allowUntrustedServer).hashCode());
        Boolean $captureGoalInputFiles = this.getCaptureGoalInputFiles();
        result = result * 59 + ($captureGoalInputFiles == null ? 43 : ((Object)$captureGoalInputFiles).hashCode());
        Boolean $uploadInBackground = this.getUploadInBackground();
        result = result * 59 + ($uploadInBackground == null ? 43 : ((Object)$uploadInBackground).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        PublishCriteria $publishCriteria = this.getPublishCriteria();
        result = result * 59 + ($publishCriteria == null ? 43 : ((Object)((Object)$publishCriteria)).hashCode());
        return result;
    }

    static class Accumulator {
        boolean mavenProject;
        boolean useCRLFNewLines;
        Path matchingExtensionsXmlFile;
        Path matchingGradleEnterpriseXmlFile;

        public boolean isMavenProject() {
            return this.mavenProject;
        }

        public boolean isUseCRLFNewLines() {
            return this.useCRLFNewLines;
        }

        public Path getMatchingExtensionsXmlFile() {
            return this.matchingExtensionsXmlFile;
        }

        public Path getMatchingGradleEnterpriseXmlFile() {
            return this.matchingGradleEnterpriseXmlFile;
        }

        public void setMavenProject(boolean mavenProject) {
            this.mavenProject = mavenProject;
        }

        public void setUseCRLFNewLines(boolean useCRLFNewLines) {
            this.useCRLFNewLines = useCRLFNewLines;
        }

        public void setMatchingExtensionsXmlFile(Path matchingExtensionsXmlFile) {
            this.matchingExtensionsXmlFile = matchingExtensionsXmlFile;
        }

        public void setMatchingGradleEnterpriseXmlFile(Path matchingGradleEnterpriseXmlFile) {
            this.matchingGradleEnterpriseXmlFile = matchingGradleEnterpriseXmlFile;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isMavenProject() != other.isMavenProject()) {
                return false;
            }
            if (this.isUseCRLFNewLines() != other.isUseCRLFNewLines()) {
                return false;
            }
            Path this$matchingExtensionsXmlFile = this.getMatchingExtensionsXmlFile();
            Path other$matchingExtensionsXmlFile = other.getMatchingExtensionsXmlFile();
            if (this$matchingExtensionsXmlFile == null ? other$matchingExtensionsXmlFile != null : !((Object)this$matchingExtensionsXmlFile).equals(other$matchingExtensionsXmlFile)) {
                return false;
            }
            Path this$matchingGradleEnterpriseXmlFile = this.getMatchingGradleEnterpriseXmlFile();
            Path other$matchingGradleEnterpriseXmlFile = other.getMatchingGradleEnterpriseXmlFile();
            return !(this$matchingGradleEnterpriseXmlFile == null ? other$matchingGradleEnterpriseXmlFile != null : !((Object)this$matchingGradleEnterpriseXmlFile).equals(other$matchingGradleEnterpriseXmlFile));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Accumulator;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isMavenProject() ? 79 : 97);
            result = result * 59 + (this.isUseCRLFNewLines() ? 79 : 97);
            Path $matchingExtensionsXmlFile = this.getMatchingExtensionsXmlFile();
            result = result * 59 + ($matchingExtensionsXmlFile == null ? 43 : ((Object)$matchingExtensionsXmlFile).hashCode());
            Path $matchingGradleEnterpriseXmlFile = this.getMatchingGradleEnterpriseXmlFile();
            result = result * 59 + ($matchingGradleEnterpriseXmlFile == null ? 43 : ((Object)$matchingGradleEnterpriseXmlFile).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "AddGradleEnterpriseMavenExtension.Accumulator(mavenProject=" + this.isMavenProject() + ", useCRLFNewLines=" + this.isUseCRLFNewLines() + ", matchingExtensionsXmlFile=" + this.getMatchingExtensionsXmlFile() + ", matchingGradleEnterpriseXmlFile=" + this.getMatchingGradleEnterpriseXmlFile() + ")";
        }
    }

    private static final class BuildScanConfiguration {
        @Nullable
        private final Boolean backgroundBuildScanUpload;
        @Nullable
        private final String publish;
        @Nullable
        private final Capture capture;

        public BuildScanConfiguration(@Nullable Boolean backgroundBuildScanUpload, @Nullable String publish, @Nullable Capture capture) {
            this.backgroundBuildScanUpload = backgroundBuildScanUpload;
            this.publish = publish;
            this.capture = capture;
        }

        @Nullable
        public Boolean getBackgroundBuildScanUpload() {
            return this.backgroundBuildScanUpload;
        }

        @Nullable
        public String getPublish() {
            return this.publish;
        }

        @Nullable
        public Capture getCapture() {
            return this.capture;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BuildScanConfiguration)) {
                return false;
            }
            BuildScanConfiguration other = (BuildScanConfiguration)o;
            Boolean this$backgroundBuildScanUpload = this.getBackgroundBuildScanUpload();
            Boolean other$backgroundBuildScanUpload = other.getBackgroundBuildScanUpload();
            if (this$backgroundBuildScanUpload == null ? other$backgroundBuildScanUpload != null : !((Object)this$backgroundBuildScanUpload).equals(other$backgroundBuildScanUpload)) {
                return false;
            }
            String this$publish = this.getPublish();
            String other$publish = other.getPublish();
            if (this$publish == null ? other$publish != null : !this$publish.equals(other$publish)) {
                return false;
            }
            Capture this$capture = this.getCapture();
            Capture other$capture = other.getCapture();
            return !(this$capture == null ? other$capture != null : !((Object)this$capture).equals(other$capture));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $backgroundBuildScanUpload = this.getBackgroundBuildScanUpload();
            result = result * 59 + ($backgroundBuildScanUpload == null ? 43 : ((Object)$backgroundBuildScanUpload).hashCode());
            String $publish = this.getPublish();
            result = result * 59 + ($publish == null ? 43 : $publish.hashCode());
            Capture $capture = this.getCapture();
            result = result * 59 + ($capture == null ? 43 : ((Object)$capture).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "AddGradleEnterpriseMavenExtension.BuildScanConfiguration(backgroundBuildScanUpload=" + this.getBackgroundBuildScanUpload() + ", publish=" + this.getPublish() + ", capture=" + this.getCapture() + ")";
        }
    }

    private static final class ServerConfiguration {
        private final String url;
        @Nullable
        private final Boolean allowUntrusted;

        public ServerConfiguration(String url, @Nullable Boolean allowUntrusted) {
            this.url = url;
            this.allowUntrusted = allowUntrusted;
        }

        public String getUrl() {
            return this.url;
        }

        @Nullable
        public Boolean getAllowUntrusted() {
            return this.allowUntrusted;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ServerConfiguration)) {
                return false;
            }
            ServerConfiguration other = (ServerConfiguration)o;
            Boolean this$allowUntrusted = this.getAllowUntrusted();
            Boolean other$allowUntrusted = other.getAllowUntrusted();
            if (this$allowUntrusted == null ? other$allowUntrusted != null : !((Object)this$allowUntrusted).equals(other$allowUntrusted)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $allowUntrusted = this.getAllowUntrusted();
            result = result * 59 + ($allowUntrusted == null ? 43 : ((Object)$allowUntrusted).hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "AddGradleEnterpriseMavenExtension.ServerConfiguration(url=" + this.getUrl() + ", allowUntrusted=" + this.getAllowUntrusted() + ")";
        }
    }

    @JacksonXmlRootElement(localName="gradleEnterprise")
    private static final class GradleEnterpriseConfiguration {
        private final ServerConfiguration server;
        @Nullable
        private final BuildScanConfiguration buildScan;

        public GradleEnterpriseConfiguration(ServerConfiguration server, @Nullable BuildScanConfiguration buildScan) {
            this.server = server;
            this.buildScan = buildScan;
        }

        public ServerConfiguration getServer() {
            return this.server;
        }

        @Nullable
        public BuildScanConfiguration getBuildScan() {
            return this.buildScan;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GradleEnterpriseConfiguration)) {
                return false;
            }
            GradleEnterpriseConfiguration other = (GradleEnterpriseConfiguration)o;
            ServerConfiguration this$server = this.getServer();
            ServerConfiguration other$server = other.getServer();
            if (this$server == null ? other$server != null : !((Object)this$server).equals(other$server)) {
                return false;
            }
            BuildScanConfiguration this$buildScan = this.getBuildScan();
            BuildScanConfiguration other$buildScan = other.getBuildScan();
            return !(this$buildScan == null ? other$buildScan != null : !((Object)this$buildScan).equals(other$buildScan));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ServerConfiguration $server = this.getServer();
            result = result * 59 + ($server == null ? 43 : ((Object)$server).hashCode());
            BuildScanConfiguration $buildScan = this.getBuildScan();
            result = result * 59 + ($buildScan == null ? 43 : ((Object)$buildScan).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "AddGradleEnterpriseMavenExtension.GradleEnterpriseConfiguration(server=" + this.getServer() + ", buildScan=" + this.getBuildScan() + ")";
        }
    }

    public static enum PublishCriteria {
        Always("ALWAYS"),
        Failure("ON_FAILURE"),
        Demand("ON_DEMAND");

        private final String xmlName;

        private PublishCriteria(String xmlName) {
            this.xmlName = xmlName;
        }
    }

    private static final class Capture {
        private final Boolean goalInputFiles;

        public Capture(Boolean goalInputFiles) {
            this.goalInputFiles = goalInputFiles;
        }

        public Boolean getGoalInputFiles() {
            return this.goalInputFiles;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Capture)) {
                return false;
            }
            Capture other = (Capture)o;
            Boolean this$goalInputFiles = this.getGoalInputFiles();
            Boolean other$goalInputFiles = other.getGoalInputFiles();
            return !(this$goalInputFiles == null ? other$goalInputFiles != null : !((Object)this$goalInputFiles).equals(other$goalInputFiles));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $goalInputFiles = this.getGoalInputFiles();
            result = result * 59 + ($goalInputFiles == null ? 43 : ((Object)$goalInputFiles).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "AddGradleEnterpriseMavenExtension.Capture(goalInputFiles=" + this.getGoalInputFiles() + ")";
        }
    }
}

