/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import java.util.List;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;

public final class Dependency {
    private final GroupArtifactVersion gav;
    @Nullable
    private final String classifier;
    @Nullable
    private final String type;
    private final String scope;
    private final List<GroupArtifact> exclusions;
    private final boolean optional;

    @Nullable
    public String getGroupId() {
        return this.gav.getGroupId();
    }

    public String getArtifactId() {
        return this.gav.getArtifactId();
    }

    @Nullable
    public String getVersion() {
        return this.gav.getVersion();
    }

    public Dependency withGav(GroupArtifactVersion gav) {
        if (gav == this.gav) {
            return this;
        }
        return new Dependency(gav, this.classifier, this.type, this.scope, this.exclusions, this.optional);
    }

    public String toString() {
        return this.gav.toString();
    }

    public Dependency(GroupArtifactVersion gav, @Nullable String classifier, @Nullable String type, String scope, List<GroupArtifact> exclusions, boolean optional) {
        this.gav = gav;
        this.classifier = classifier;
        this.type = type;
        this.scope = scope;
        this.exclusions = exclusions;
        this.optional = optional;
    }

    public GroupArtifactVersion getGav() {
        return this.gav;
    }

    @Nullable
    public String getClassifier() {
        return this.classifier;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public String getScope() {
        return this.scope;
    }

    public List<GroupArtifact> getExclusions() {
        return this.exclusions;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Dependency)) {
            return false;
        }
        Dependency other = (Dependency)o;
        if (this.isOptional() != other.isOptional()) {
            return false;
        }
        GroupArtifactVersion this$gav = this.getGav();
        GroupArtifactVersion other$gav = other.getGav();
        if (this$gav == null ? other$gav != null : !((Object)this$gav).equals(other$gav)) {
            return false;
        }
        String this$classifier = this.getClassifier();
        String other$classifier = other.getClassifier();
        if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        List<GroupArtifact> this$exclusions = this.getExclusions();
        List<GroupArtifact> other$exclusions = other.getExclusions();
        return !(this$exclusions == null ? other$exclusions != null : !((Object)this$exclusions).equals(other$exclusions));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOptional() ? 79 : 97);
        GroupArtifactVersion $gav = this.getGav();
        result = result * 59 + ($gav == null ? 43 : ((Object)$gav).hashCode());
        String $classifier = this.getClassifier();
        result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        List<GroupArtifact> $exclusions = this.getExclusions();
        result = result * 59 + ($exclusions == null ? 43 : ((Object)$exclusions).hashCode());
        return result;
    }

    @NonNull
    public Dependency withClassifier(@Nullable String classifier) {
        return this.classifier == classifier ? this : new Dependency(this.gav, classifier, this.type, this.scope, this.exclusions, this.optional);
    }

    @NonNull
    public Dependency withType(@Nullable String type) {
        return this.type == type ? this : new Dependency(this.gav, this.classifier, type, this.scope, this.exclusions, this.optional);
    }

    @NonNull
    public Dependency withScope(String scope) {
        return this.scope == scope ? this : new Dependency(this.gav, this.classifier, this.type, scope, this.exclusions, this.optional);
    }

    @NonNull
    public Dependency withExclusions(List<GroupArtifact> exclusions) {
        return this.exclusions == exclusions ? this : new Dependency(this.gav, this.classifier, this.type, this.scope, exclusions, this.optional);
    }

    @NonNull
    public Dependency withOptional(boolean optional) {
        return this.optional == optional ? this : new Dependency(this.gav, this.classifier, this.type, this.scope, this.exclusions, optional);
    }
}

