/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.xml.tree.Xml;

public final class RemoveRedundantDependencyVersions
extends Recipe {
    @Option(displayName="Group", description="Group glob expression pattern used to match dependencies that should be managed.Group is the first part of a dependency coordinate 'com.google.guava:guava:VERSION'.", example="com.google.*", required=false)
    @Nullable
    private final String groupPattern;
    @Option(displayName="Artifact", description="Artifact glob expression pattern used to match dependencies that should be managed.Artifact is the second part of a dependency coordinate 'com.google.guava:guava:VERSION'.", example="guava*", required=false)
    @Nullable
    private final String artifactPattern;
    @Option(displayName="Only if versions match", description="Only remove the explicit version if it matches the managed dependency version. Default true.", example="false", required=false)
    @Nullable
    private final Boolean onlyIfVersionsMatch;
    @Option(displayName="Except", description="Accepts a list of GAVs. Dependencies matching a GAV will be ignored by this recipe. GAV versions are ignored if provided.", example="- com.jcraft:jsch", required=false)
    @Nullable
    private final List<String> except;

    public String getDisplayName() {
        return "Remove redundant explicit dependency versions";
    }

    public String getDescription() {
        return "Remove explicitly-specified dependency versions when a parent POM's dependencyManagement specifies the version.";
    }

    public Validated validate() {
        Validated.None validated = Validated.none();
        if (this.except != null) {
            for (int i = 0; i < this.except.size(); ++i) {
                String retainVersion = this.except.get(i);
                validated = validated.and(Validated.test((String)String.format("except[%d]", i), (String)"did not look like a two-or-three-part GAV", (Object)retainVersion, maybeGav -> {
                    int gavParts = maybeGav.split(":").length;
                    return gavParts == 2 || gavParts == 3;
                }));
            }
        }
        return validated;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                ResolvedDependency d;
                if (!this.isManagedDependencyTag() && (d = this.findDependency(tag)) != null && this.matchesVersion(d) && this.matchesGroup(d) && this.matchesArtifact(d) && this.isNotExcepted(d)) {
                    Xml.Tag version = tag.getChild("version").orElse(null);
                    return tag.withContent(ListUtils.map((List)tag.getContent(), c -> c == version ? null : c));
                }
                return super.visitTag(tag, ctx);
            }

            private boolean matchesGroup(ResolvedDependency d) {
                return StringUtils.isNullOrEmpty((String)RemoveRedundantDependencyVersions.this.groupPattern) || StringUtils.matchesGlob((String)d.getGroupId(), (String)RemoveRedundantDependencyVersions.this.groupPattern);
            }

            private boolean matchesArtifact(ResolvedDependency d) {
                return StringUtils.isNullOrEmpty((String)RemoveRedundantDependencyVersions.this.artifactPattern) || StringUtils.matchesGlob((String)d.getArtifactId(), (String)RemoveRedundantDependencyVersions.this.artifactPattern);
            }

            private boolean matchesVersion(ResolvedDependency d) {
                return this.ignoreVersionMatching() || d.getRequested().getVersion() != null && d.getRequested().getVersion().equals(this.getResolutionResult().getPom().getManagedVersion(d.getGroupId(), d.getArtifactId(), d.getRequested().getType(), d.getRequested().getClassifier()));
            }

            private boolean ignoreVersionMatching() {
                return Boolean.FALSE.equals(RemoveRedundantDependencyVersions.this.onlyIfVersionsMatch);
            }

            private boolean isNotExcepted(ResolvedDependency d) {
                if (RemoveRedundantDependencyVersions.this.except == null) {
                    return true;
                }
                for (String gav : RemoveRedundantDependencyVersions.this.except) {
                    String[] split = gav.split(":");
                    String exceptedGroupId = split[0];
                    String exceptedArtifactId = split[1];
                    if (!StringUtils.matchesGlob((String)d.getGroupId(), (String)exceptedGroupId) || !StringUtils.matchesGlob((String)d.getArtifactId(), (String)exceptedArtifactId)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public RemoveRedundantDependencyVersions(@Nullable String groupPattern, @Nullable String artifactPattern, @Nullable Boolean onlyIfVersionsMatch, @Nullable List<String> except) {
        this.groupPattern = groupPattern;
        this.artifactPattern = artifactPattern;
        this.onlyIfVersionsMatch = onlyIfVersionsMatch;
        this.except = except;
    }

    @Nullable
    public String getGroupPattern() {
        return this.groupPattern;
    }

    @Nullable
    public String getArtifactPattern() {
        return this.artifactPattern;
    }

    @Nullable
    public Boolean getOnlyIfVersionsMatch() {
        return this.onlyIfVersionsMatch;
    }

    @Nullable
    public List<String> getExcept() {
        return this.except;
    }

    @NonNull
    public String toString() {
        return "RemoveRedundantDependencyVersions(groupPattern=" + this.getGroupPattern() + ", artifactPattern=" + this.getArtifactPattern() + ", onlyIfVersionsMatch=" + this.getOnlyIfVersionsMatch() + ", except=" + this.getExcept() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveRedundantDependencyVersions)) {
            return false;
        }
        RemoveRedundantDependencyVersions other = (RemoveRedundantDependencyVersions)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$onlyIfVersionsMatch = this.getOnlyIfVersionsMatch();
        Boolean other$onlyIfVersionsMatch = other.getOnlyIfVersionsMatch();
        if (this$onlyIfVersionsMatch == null ? other$onlyIfVersionsMatch != null : !((Object)this$onlyIfVersionsMatch).equals(other$onlyIfVersionsMatch)) {
            return false;
        }
        String this$groupPattern = this.getGroupPattern();
        String other$groupPattern = other.getGroupPattern();
        if (this$groupPattern == null ? other$groupPattern != null : !this$groupPattern.equals(other$groupPattern)) {
            return false;
        }
        String this$artifactPattern = this.getArtifactPattern();
        String other$artifactPattern = other.getArtifactPattern();
        if (this$artifactPattern == null ? other$artifactPattern != null : !this$artifactPattern.equals(other$artifactPattern)) {
            return false;
        }
        List<String> this$except = this.getExcept();
        List<String> other$except = other.getExcept();
        return !(this$except == null ? other$except != null : !((Object)this$except).equals(other$except));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveRedundantDependencyVersions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $onlyIfVersionsMatch = this.getOnlyIfVersionsMatch();
        result = result * 59 + ($onlyIfVersionsMatch == null ? 43 : ((Object)$onlyIfVersionsMatch).hashCode());
        String $groupPattern = this.getGroupPattern();
        result = result * 59 + ($groupPattern == null ? 43 : $groupPattern.hashCode());
        String $artifactPattern = this.getArtifactPattern();
        result = result * 59 + ($artifactPattern == null ? 43 : $artifactPattern.hashCode());
        List<String> $except = this.getExcept();
        result = result * 59 + ($except == null ? 43 : ((Object)$except).hashCode());
        return result;
    }
}

