/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.PropertyPlaceholderHelper;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.internal.MavenXmlMapper;
import org.openrewrite.maven.internal.RawRepositories;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.ProfileActivation;

public class MavenSettings {
    @Nullable
    private final String localRepository;
    @Nullable
    private MavenRepository mavenLocal;
    @Nullable
    private final Profiles profiles;
    @Nullable
    private final ActiveProfiles activeProfiles;
    @Nullable
    private final Mirrors mirrors;
    @Nullable
    private final Servers servers;

    @JsonCreator
    public MavenSettings(@Nullable String localRepository, @Nullable Profiles profiles, @Nullable ActiveProfiles activeProfiles, @Nullable Mirrors mirrors, @Nullable Servers servers) {
        this.localRepository = localRepository;
        this.profiles = profiles;
        this.activeProfiles = activeProfiles;
        this.mirrors = mirrors;
        this.servers = servers;
    }

    @Nullable
    public static MavenSettings parse(Parser.Input source, ExecutionContext ctx) {
        try {
            return new Interpolator().interpolate((MavenSettings)MavenXmlMapper.readMapper().readValue((InputStream)source.getSource(ctx), MavenSettings.class));
        }
        catch (IOException e) {
            ctx.getOnError().accept(new IOException("Failed to parse " + source.getPath(), e));
            return null;
        }
    }

    @Nullable
    public static MavenSettings parse(Path settingsPath, ExecutionContext ctx) {
        return MavenSettings.parse(new Parser.Input(settingsPath, () -> {
            try {
                return Files.newInputStream(settingsPath, new OpenOption[0]);
            }
            catch (IOException e) {
                ctx.getOnError().accept(new IOException("Failed to read settings.xml at " + settingsPath, e));
                return null;
            }
        }), ctx);
    }

    @Nullable
    public static MavenSettings readMavenSettingsFromDisk(ExecutionContext ctx) {
        Optional<MavenSettings> userSettings = Optional.of(MavenSettings.userSettingsPath()).filter(MavenSettings::exists).map(path -> MavenSettings.parse(path, ctx));
        MavenSettings installSettings = MavenSettings.findMavenHomeSettings().map(path -> MavenSettings.parse(path, ctx)).orElse(null);
        return userSettings.map(mavenSettings -> mavenSettings.merge(installSettings)).orElse(installSettings);
    }

    public static boolean readFromDiskEnabled() {
        String propertyValue = System.getProperty("org.openrewrite.test.readMavenSettingsFromDisk");
        return propertyValue != null && !propertyValue.equalsIgnoreCase("false");
    }

    private static Path userSettingsPath() {
        return Paths.get(System.getProperty("user.home"), new String[0]).resolve(".m2/settings.xml");
    }

    private static Optional<Path> findMavenHomeSettings() {
        for (String envVariable : Arrays.asList("MVN_HOME", "M2_HOME", "MAVEN_HOME")) {
            for (String s : Optional.ofNullable(System.getenv(envVariable)).map(xva$0 -> Arrays.asList(xva$0)).orElse(Collections.emptyList())) {
                Path resolve = Paths.get(s, new String[0]).resolve("conf/settings.xml");
                if (!MavenSettings.exists(resolve)) continue;
                return Optional.of(resolve);
            }
        }
        return Optional.empty();
    }

    private static boolean exists(Path path) {
        try {
            return path.toFile().exists();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public MavenSettings merge(@Nullable MavenSettings installSettings) {
        return installSettings == null ? this : new MavenSettings(this.localRepository == null ? installSettings.localRepository : this.localRepository, this.profiles == null ? installSettings.profiles : this.profiles.merge(installSettings.profiles), this.activeProfiles == null ? installSettings.activeProfiles : this.activeProfiles.merge(installSettings.activeProfiles), this.mirrors == null ? installSettings.mirrors : this.mirrors.merge(installSettings.mirrors), this.servers == null ? installSettings.servers : this.servers.merge(installSettings.servers));
    }

    public List<RawRepositories.Repository> getActiveRepositories(Iterable<String> activeProfiles) {
        ArrayList<RawRepositories.Repository> activeRepositories = new ArrayList<RawRepositories.Repository>();
        if (this.profiles != null) {
            for (Profile profile : this.profiles.getProfiles()) {
                if (!profile.isActive(activeProfiles) && (this.activeProfiles == null || !profile.isActive(this.activeProfiles.getActiveProfiles())) || profile.repositories == null) continue;
                activeRepositories.addAll(profile.repositories.getRepositories());
            }
        }
        return activeRepositories;
    }

    public MavenRepository getMavenLocal() {
        if (this.localRepository == null) {
            return MavenRepository.MAVEN_LOCAL_DEFAULT;
        }
        if (this.mavenLocal == null) {
            this.mavenLocal = new MavenRepository("local", MavenSettings.asUriString(this.localRepository), true, true, true, null, null, false);
        }
        return this.mavenLocal;
    }

    private static String asUriString(String pathname) {
        return pathname.startsWith("file://") ? pathname : Paths.get(pathname, new String[0]).toUri().toString();
    }

    @NonNull
    public String toString() {
        return "MavenSettings()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MavenSettings)) {
            return false;
        }
        MavenSettings other = (MavenSettings)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof MavenSettings;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Nullable
    public String getLocalRepository() {
        return this.localRepository;
    }

    @Nullable
    public Profiles getProfiles() {
        return this.profiles;
    }

    @Nullable
    public ActiveProfiles getActiveProfiles() {
        return this.activeProfiles;
    }

    @Nullable
    public Mirrors getMirrors() {
        return this.mirrors;
    }

    @Nullable
    public Servers getServers() {
        return this.servers;
    }

    public void setMavenLocal(@Nullable MavenRepository mavenLocal) {
        this.mavenLocal = mavenLocal;
    }

    public MavenSettings(@Nullable String localRepository, @Nullable MavenRepository mavenLocal, @Nullable Profiles profiles, @Nullable ActiveProfiles activeProfiles, @Nullable Mirrors mirrors, @Nullable Servers servers) {
        this.localRepository = localRepository;
        this.mavenLocal = mavenLocal;
        this.profiles = profiles;
        this.activeProfiles = activeProfiles;
        this.mirrors = mirrors;
        this.servers = servers;
    }

    @NonNull
    public MavenSettings withServers(@Nullable Servers servers) {
        return this.servers == servers ? this : new MavenSettings(this.localRepository, this.mavenLocal, this.profiles, this.activeProfiles, this.mirrors, servers);
    }

    public static class Servers {
        @JacksonXmlProperty(localName="server")
        @JacksonXmlElementWrapper(useWrapping=false)
        private List<Server> servers = Collections.emptyList();

        public Servers merge(@Nullable Servers servers) {
            LinkedHashMap<String, Server> merged = new LinkedHashMap<String, Server>();
            for (Server server2 : this.servers) {
                merged.put(server2.id, server2);
            }
            if (servers != null) {
                servers.getServers().forEach(server -> merged.putIfAbsent(server.getId(), (Server)server));
            }
            return new Servers(new ArrayList<Server>(merged.values()));
        }

        public List<Server> getServers() {
            return this.servers;
        }

        @JacksonXmlProperty(localName="server")
        @JacksonXmlElementWrapper(useWrapping=false)
        public void setServers(List<Server> servers) {
            this.servers = servers;
        }

        public Servers(List<Server> servers) {
            this.servers = servers;
        }

        public Servers() {
        }

        @NonNull
        public Servers withServers(List<Server> servers) {
            return this.servers == servers ? this : new Servers(servers);
        }
    }

    public static class Mirrors {
        @JacksonXmlProperty(localName="mirror")
        @JacksonXmlElementWrapper(useWrapping=false)
        private List<Mirror> mirrors = Collections.emptyList();

        public Mirrors merge(@Nullable Mirrors mirrors) {
            LinkedHashMap<String, Mirror> merged = new LinkedHashMap<String, Mirror>();
            for (Mirror mirror2 : this.mirrors) {
                merged.put(mirror2.id, mirror2);
            }
            if (mirrors != null) {
                mirrors.getMirrors().forEach(mirror -> merged.putIfAbsent(mirror.getId(), (Mirror)mirror));
            }
            return new Mirrors(new ArrayList<Mirror>(merged.values()));
        }

        public List<Mirror> getMirrors() {
            return this.mirrors;
        }

        @JacksonXmlProperty(localName="mirror")
        @JacksonXmlElementWrapper(useWrapping=false)
        public void setMirrors(List<Mirror> mirrors) {
            this.mirrors = mirrors;
        }

        public Mirrors(List<Mirror> mirrors) {
            this.mirrors = mirrors;
        }

        public Mirrors() {
        }
    }

    public static class ActiveProfiles {
        @JacksonXmlProperty(localName="activeProfile")
        @JacksonXmlElementWrapper(useWrapping=false)
        private List<String> activeProfiles = Collections.emptyList();

        public ActiveProfiles merge(@Nullable ActiveProfiles activeProfiles) {
            if (activeProfiles == null) {
                return new ActiveProfiles(new ArrayList<String>(this.activeProfiles));
            }
            ArrayList<String> result = new ArrayList<String>();
            HashSet<String> uniqueValues = new HashSet<String>();
            for (String s : ListUtils.concatAll(this.activeProfiles, activeProfiles.activeProfiles)) {
                if (!uniqueValues.add(s)) continue;
                result.add(s);
            }
            return new ActiveProfiles(result);
        }

        public List<String> getActiveProfiles() {
            return this.activeProfiles;
        }

        @JacksonXmlProperty(localName="activeProfile")
        @JacksonXmlElementWrapper(useWrapping=false)
        public void setActiveProfiles(List<String> activeProfiles) {
            this.activeProfiles = activeProfiles;
        }

        public ActiveProfiles(List<String> activeProfiles) {
            this.activeProfiles = activeProfiles;
        }

        public ActiveProfiles() {
        }
    }

    public static class Profiles {
        @JacksonXmlProperty(localName="profile")
        @JacksonXmlElementWrapper(useWrapping=false)
        private List<Profile> profiles = Collections.emptyList();

        public Profiles merge(@Nullable Profiles profiles) {
            LinkedHashMap<String, Profile> merged = new LinkedHashMap<String, Profile>();
            for (Profile profile2 : this.profiles) {
                merged.put(profile2.id, profile2);
            }
            if (profiles != null) {
                profiles.getProfiles().forEach(profile -> merged.putIfAbsent(profile.getId(), (Profile)profile));
            }
            return new Profiles(new ArrayList<Profile>(merged.values()));
        }

        public List<Profile> getProfiles() {
            return this.profiles;
        }

        @JacksonXmlProperty(localName="profile")
        @JacksonXmlElementWrapper(useWrapping=false)
        public void setProfiles(List<Profile> profiles) {
            this.profiles = profiles;
        }

        public Profiles(List<Profile> profiles) {
            this.profiles = profiles;
        }

        public Profiles() {
        }
    }

    private static class Interpolator {
        private static final PropertyPlaceholderHelper propertyPlaceholders = new PropertyPlaceholderHelper("${", "}", null);
        private static final UnaryOperator<String> propertyResolver = key -> {
            String property = System.getProperty(key);
            if (property != null) {
                return property;
            }
            if (key.startsWith("env.")) {
                return System.getenv().get(key.substring(4));
            }
            return null;
        };

        private Interpolator() {
        }

        public MavenSettings interpolate(MavenSettings mavenSettings) {
            return new MavenSettings(this.interpolate(mavenSettings.localRepository), mavenSettings.profiles, this.interpolate(mavenSettings.activeProfiles), this.interpolate(mavenSettings.mirrors), this.interpolate(mavenSettings.servers));
        }

        @Nullable
        private ActiveProfiles interpolate(@Nullable ActiveProfiles activeProfiles) {
            if (activeProfiles == null) {
                return null;
            }
            return new ActiveProfiles(ListUtils.map(activeProfiles.getActiveProfiles(), this::interpolate));
        }

        @Nullable
        private Mirrors interpolate(@Nullable Mirrors mirrors) {
            if (mirrors == null) {
                return null;
            }
            return new Mirrors(ListUtils.map(mirrors.getMirrors(), this::interpolate));
        }

        private Mirror interpolate(Mirror mirror) {
            return new Mirror(this.interpolate(mirror.id), this.interpolate(mirror.url), this.interpolate(mirror.getMirrorOf()), mirror.releases, mirror.snapshots);
        }

        @Nullable
        private Servers interpolate(@Nullable Servers servers) {
            if (servers == null) {
                return null;
            }
            return new Servers(ListUtils.map(servers.getServers(), this::interpolate));
        }

        private Server interpolate(Server server) {
            return new Server(this.interpolate(server.id), this.interpolate(server.username), this.interpolate(server.password));
        }

        @Nullable
        private String interpolate(@Nullable String s) {
            return s == null ? null : propertyPlaceholders.replacePlaceholders(s, propertyResolver);
        }
    }

    public static class Profile {
        @Nullable
        private final String id;
        @Nullable
        private final ProfileActivation activation;
        @Nullable
        private final RawRepositories repositories;

        public boolean isActive(Iterable<String> activeProfiles) {
            return ProfileActivation.isActive(this.id, activeProfiles, this.activation);
        }

        public boolean isActive(String ... activeProfiles) {
            return this.isActive(Arrays.asList(activeProfiles));
        }

        public Profile(@Nullable String id, @Nullable ProfileActivation activation, @Nullable RawRepositories repositories) {
            this.id = id;
            this.activation = activation;
            this.repositories = repositories;
        }

        @Nullable
        public String getId() {
            return this.id;
        }

        @Nullable
        public ProfileActivation getActivation() {
            return this.activation;
        }

        @Nullable
        public RawRepositories getRepositories() {
            return this.repositories;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Profile)) {
                return false;
            }
            Profile other = (Profile)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            ProfileActivation this$activation = this.getActivation();
            ProfileActivation other$activation = other.getActivation();
            if (this$activation == null ? other$activation != null : !((Object)this$activation).equals(other$activation)) {
                return false;
            }
            RawRepositories this$repositories = this.getRepositories();
            RawRepositories other$repositories = other.getRepositories();
            return !(this$repositories == null ? other$repositories != null : !this$repositories.equals(other$repositories));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Profile;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            ProfileActivation $activation = this.getActivation();
            result = result * 59 + ($activation == null ? 43 : ((Object)$activation).hashCode());
            RawRepositories $repositories = this.getRepositories();
            result = result * 59 + ($repositories == null ? 43 : $repositories.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "MavenSettings.Profile(id=" + this.getId() + ", activation=" + this.getActivation() + ", repositories=" + this.getRepositories() + ")";
        }
    }

    public static class Server {
        private final String id;
        private final String username;
        private final String password;

        public Server(String id, String username, String password) {
            this.id = id;
            this.username = username;
            this.password = password;
        }

        public String getId() {
            return this.id;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Server)) {
                return false;
            }
            Server other = (Server)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            return !(this$password == null ? other$password != null : !this$password.equals(other$password));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Server;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "MavenSettings.Server(id=" + this.getId() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
        }

        @NonNull
        public Server withId(String id) {
            return this.id == id ? this : new Server(id, this.username, this.password);
        }

        @NonNull
        public Server withUsername(String username) {
            return this.username == username ? this : new Server(this.id, username, this.password);
        }

        @NonNull
        public Server withPassword(String password) {
            return this.password == password ? this : new Server(this.id, this.username, password);
        }
    }

    public static class Mirror {
        @Nullable
        private final String id;
        @Nullable
        private final String url;
        @Nullable
        private final String mirrorOf;
        @Nullable
        private final Boolean releases;
        @Nullable
        private final Boolean snapshots;

        public Mirror(@Nullable String id, @Nullable String url, @Nullable String mirrorOf, @Nullable Boolean releases, @Nullable Boolean snapshots) {
            this.id = id;
            this.url = url;
            this.mirrorOf = mirrorOf;
            this.releases = releases;
            this.snapshots = snapshots;
        }

        @Nullable
        public String getId() {
            return this.id;
        }

        @Nullable
        public String getUrl() {
            return this.url;
        }

        @Nullable
        public String getMirrorOf() {
            return this.mirrorOf;
        }

        @Nullable
        public Boolean getReleases() {
            return this.releases;
        }

        @Nullable
        public Boolean getSnapshots() {
            return this.snapshots;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Mirror)) {
                return false;
            }
            Mirror other = (Mirror)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$releases = this.getReleases();
            Boolean other$releases = other.getReleases();
            if (this$releases == null ? other$releases != null : !((Object)this$releases).equals(other$releases)) {
                return false;
            }
            Boolean this$snapshots = this.getSnapshots();
            Boolean other$snapshots = other.getSnapshots();
            if (this$snapshots == null ? other$snapshots != null : !((Object)this$snapshots).equals(other$snapshots)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$mirrorOf = this.getMirrorOf();
            String other$mirrorOf = other.getMirrorOf();
            return !(this$mirrorOf == null ? other$mirrorOf != null : !this$mirrorOf.equals(other$mirrorOf));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Mirror;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $releases = this.getReleases();
            result = result * 59 + ($releases == null ? 43 : ((Object)$releases).hashCode());
            Boolean $snapshots = this.getSnapshots();
            result = result * 59 + ($snapshots == null ? 43 : ((Object)$snapshots).hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $mirrorOf = this.getMirrorOf();
            result = result * 59 + ($mirrorOf == null ? 43 : $mirrorOf.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "MavenSettings.Mirror(id=" + this.getId() + ", url=" + this.getUrl() + ", mirrorOf=" + this.getMirrorOf() + ", releases=" + this.getReleases() + ", snapshots=" + this.getSnapshots() + ")";
        }
    }
}

