/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.cleanup.ModifierOrder;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.Markers;

public class FinalClassVisitor
extends JavaIsoVisitor<ExecutionContext> {
    Tree visitRoot;
    final Set<String> typesToFinalize = new HashSet<String>();
    final Set<String> typesToNotFinalize = new HashSet<String>();

    @Nullable
    public J visit(@Nullable Tree tree, ExecutionContext ctx) {
        boolean root = false;
        if (this.visitRoot == null && tree != null) {
            this.visitRoot = tree;
            root = true;
        }
        J result = (J)super.visit(tree, (Object)ctx);
        if (root) {
            this.visitRoot = null;
            this.typesToFinalize.removeAll(this.typesToNotFinalize);
            if (!this.typesToFinalize.isEmpty()) {
                result = (J)new FinalizingVisitor(this.typesToFinalize).visit(tree, ctx);
            }
        }
        return result;
    }

    @Override
    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDeclaration, ExecutionContext ctx) {
        J cd = super.visitClassDeclaration(classDeclaration, ctx);
        if (((J.ClassDeclaration)cd).getKind() != J.ClassDeclaration.Kind.Type.Class || ((J.ClassDeclaration)cd).hasModifier(J.Modifier.Type.Abstract) || ((J.ClassDeclaration)cd).hasModifier(J.Modifier.Type.Final) || ((J.ClassDeclaration)cd).getType() == null) {
            return cd;
        }
        this.excludeSupertypes(((J.ClassDeclaration)cd).getType());
        boolean allPrivate = true;
        int constructorCount = 0;
        for (Statement s : ((J.ClassDeclaration)cd).getBody().getStatements()) {
            if (s instanceof J.MethodDeclaration && ((J.MethodDeclaration)s).isConstructor()) {
                J.MethodDeclaration constructor = (J.MethodDeclaration)s;
                ++constructorCount;
                if (!constructor.hasModifier(J.Modifier.Type.Private)) {
                    allPrivate = false;
                }
            }
            if (constructorCount <= 0 || allPrivate) continue;
            return cd;
        }
        if (constructorCount > 0) {
            this.typesToFinalize.add(((J.ClassDeclaration)cd).getType().getFullyQualifiedName());
        }
        return cd;
    }

    private void excludeSupertypes(JavaType.FullyQualified type) {
        if (type.getSupertype() != null && type.getOwningClass() != null && this.typesToNotFinalize.add(type.getSupertype().getFullyQualifiedName())) {
            this.excludeSupertypes(type.getSupertype());
        }
    }

    private static class FinalizingVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final Set<String> typesToFinalize;

        public FinalizingVisitor(Set<String> typesToFinalize) {
            this.typesToFinalize = typesToFinalize;
        }

        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J cd = super.visitClassDeclaration(classDecl, ctx);
            if (((J.ClassDeclaration)cd).getType() != null && this.typesToFinalize.remove(((J.ClassDeclaration)cd).getType().getFullyQualifiedName())) {
                List<J.Modifier> modifiers = new ArrayList<J.Modifier>(((J.ClassDeclaration)cd).getModifiers());
                modifiers.add(new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, J.Modifier.Type.Final, Collections.emptyList()));
                modifiers = ModifierOrder.sortModifiers(modifiers);
                cd = ((J.ClassDeclaration)cd).withModifiers(modifiers);
                if (((J.ClassDeclaration)cd).getType() instanceof JavaType.Class && !((J.ClassDeclaration)cd).getType().hasFlags(Flag.Final)) {
                    HashSet<Flag> flags = new HashSet<Flag>(((J.ClassDeclaration)cd).getType().getFlags());
                    flags.add(Flag.Final);
                    cd = ((J.ClassDeclaration)cd).withType(((JavaType.Class)((J.ClassDeclaration)cd).getType()).withFlags(flags));
                }
                if (!((J.ClassDeclaration)cd).getLeadingAnnotations().isEmpty()) {
                    cd = ((J.ClassDeclaration)cd).getAnnotations().withKind(((J.ClassDeclaration)cd).getAnnotations().getKind().withPrefix(Space.EMPTY));
                }
                assert (this.getCursor().getParent() != null);
                cd = (J.ClassDeclaration)this.autoFormat(cd, ((J.ClassDeclaration)cd).getName(), ctx, this.getCursor().getParent());
            }
            return cd;
        }
    }
}

