/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.regex.Pattern;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;

public class UsesType<P>
extends JavaIsoVisitor<P> {
    private final Pattern typePattern;

    public UsesType(String fullyQualifiedType) {
        this.typePattern = Pattern.compile(StringUtils.aspectjNameToPattern((String)fullyQualifiedType));
    }

    @Override
    public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, P p) {
        JavaSourceFile c = cu;
        for (JavaType.Method method : c.getTypesInUse().getUsedMethods()) {
            if (!method.hasFlags(Flag.Static) || (c = this.maybeMark(c, method.getDeclaringType())) == cu) continue;
            return c;
        }
        for (JavaType type : c.getTypesInUse().getTypesInUse()) {
            JavaType checkType = type instanceof JavaType.Primitive ? type : TypeUtils.asFullyQualified(type);
            if ((c = this.maybeMark(c, checkType)) == cu) continue;
            return c;
        }
        for (J.Import anImport : c.getImports()) {
            if (!(anImport.isStatic() ? (c = this.maybeMark(c, TypeUtils.asFullyQualified(anImport.getQualid().getTarget().getType()))) != cu : (c = this.maybeMark(c, TypeUtils.asFullyQualified(anImport.getQualid().getType()))) != cu)) continue;
            return c;
        }
        return c;
    }

    private JavaSourceFile maybeMark(JavaSourceFile c, @Nullable JavaType type) {
        if (type == null) {
            return c;
        }
        if (TypeUtils.isAssignableTo(this.typePattern, type)) {
            return (JavaSourceFile)SearchResult.found((Tree)c);
        }
        return c;
    }
}

