/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal;

import java.util.HashSet;
import java.util.Set;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypedTree;

public class TypesInUse {
    private final JavaSourceFile cu;
    private final Set<JavaType> typesInUse;
    private final Set<JavaType.Method> declaredMethods;
    private final Set<JavaType.Method> usedMethods;
    private final Set<JavaType.Variable> variables;

    public static TypesInUse build(JavaSourceFile cu) {
        FindTypesInUse findTypesInUse = new FindTypesInUse();
        findTypesInUse.visit(cu, 0);
        return new TypesInUse(cu, findTypesInUse.getTypes(), findTypesInUse.getDeclaredMethods(), findTypesInUse.getUsedMethods(), findTypesInUse.getVariables());
    }

    private TypesInUse(JavaSourceFile cu, Set<JavaType> typesInUse, Set<JavaType.Method> declaredMethods, Set<JavaType.Method> usedMethods, Set<JavaType.Variable> variables) {
        this.cu = cu;
        this.typesInUse = typesInUse;
        this.declaredMethods = declaredMethods;
        this.usedMethods = usedMethods;
        this.variables = variables;
    }

    public JavaSourceFile getCu() {
        return this.cu;
    }

    public Set<JavaType> getTypesInUse() {
        return this.typesInUse;
    }

    public Set<JavaType.Method> getDeclaredMethods() {
        return this.declaredMethods;
    }

    public Set<JavaType.Method> getUsedMethods() {
        return this.usedMethods;
    }

    public Set<JavaType.Variable> getVariables() {
        return this.variables;
    }

    public static class FindTypesInUse
    extends JavaIsoVisitor<Integer> {
        private final Set<JavaType> types = new NullSkippingSet<JavaType>();
        private final Set<JavaType.Method> declaredMethods = new NullSkippingSet<JavaType.Method>();
        private final Set<JavaType.Method> usedMethods = new NullSkippingSet<JavaType.Method>();
        private final Set<JavaType.Variable> variables = new NullSkippingSet<JavaType.Variable>();

        public J preVisit(J tree, Integer integer) {
            if (!(!(tree instanceof TypedTree) || tree instanceof J.ClassDeclaration || tree instanceof J.MethodDeclaration || tree instanceof J.MethodInvocation || tree instanceof J.Lambda || tree instanceof J.VariableDeclarations)) {
                this.types.add(((TypedTree)tree).getType());
            }
            return tree;
        }

        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration c, Integer p) {
            this.visitSpace(c.getPrefix(), Space.Location.ANY, p);
            for (J.Annotation annotation : c.getAllAnnotations()) {
                this.visit(annotation, p);
            }
            if (c.getPadding().getTypeParameters() != null) {
                this.visitContainer(c.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, p);
            }
            if (c.getPadding().getExtends() != null) {
                this.visitLeftPadded(c.getPadding().getExtends(), JLeftPadded.Location.EXTENDS, p);
            }
            if (c.getPadding().getImplements() != null) {
                this.visitContainer(c.getPadding().getImplements(), JContainer.Location.IMPLEMENTS, p);
            }
            this.visit(c.getBody(), p);
            return c;
        }

        @Override
        public J.Identifier visitIdentifier(J.Identifier identifier, Integer p) {
            this.variables.add(identifier.getFieldType());
            return super.visitIdentifier(identifier, p);
        }

        @Override
        public J.Import visitImport(J.Import impoort, Integer p) {
            return impoort;
        }

        @Override
        public J.Package visitPackage(J.Package pkg, Integer p) {
            for (J.Annotation annotation : pkg.getAnnotations()) {
                this.visit(annotation, p);
            }
            return pkg;
        }

        @Override
        public J.MemberReference visitMemberReference(J.MemberReference memberRef, Integer p) {
            this.usedMethods.add(memberRef.getMethodType());
            this.variables.add(memberRef.getVariableType());
            return super.visitMemberReference(memberRef, p);
        }

        @Override
        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, Integer p) {
            this.declaredMethods.add(method.getMethodType());
            return super.visitMethodDeclaration(method, p);
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, Integer p) {
            this.usedMethods.add(method.getMethodType());
            return super.visitMethodInvocation(method, p);
        }

        @Override
        public J.NewClass visitNewClass(J.NewClass newClass, Integer integer) {
            this.usedMethods.add(newClass.getConstructorType());
            return super.visitNewClass(newClass, integer);
        }

        public Set<JavaType> getTypes() {
            return this.types;
        }

        public Set<JavaType.Method> getDeclaredMethods() {
            return this.declaredMethods;
        }

        public Set<JavaType.Method> getUsedMethods() {
            return this.usedMethods;
        }

        public Set<JavaType.Variable> getVariables() {
            return this.variables;
        }
    }

    private static class NullSkippingSet<T>
    extends HashSet<T> {
        private NullSkippingSet() {
        }

        @Override
        public boolean add(@Nullable T t) {
            if (t != null) {
                return super.add(t);
            }
            return false;
        }
    }
}

