/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.JavadocVisitor;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Javadoc;

@Incubating(since="7.33.0")
public class RemoveEmptyJavaDocParameters
extends Recipe {
    public String getDisplayName() {
        return "Remove JavaDoc `@params`, `@return`, and `@throws` with no description";
    }

    public String getDescription() {
        return "Removes `@params`, `@return`, and `@throws` with no description from JavaDocs.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            final RemoveEmptyParamVisitor removeEmptyParamVisitor = new RemoveEmptyParamVisitor();

            @Nullable
            public J visitSourceFile(SourceFile sourceFile, ExecutionContext executionContext) {
                return (J)super.visitSourceFile(sourceFile, (Object)executionContext);
            }

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext executionContext) {
                J md = super.visitMethodDeclaration(method, executionContext);
                if (md.getComments().stream().anyMatch(it -> it instanceof Javadoc.DocComment)) {
                    md = (J.MethodDeclaration)md.withComments(ListUtils.map(md.getComments(), it -> {
                        if (it instanceof Javadoc.DocComment) {
                            Javadoc.DocComment docComment = (Javadoc.DocComment)it;
                            return (Comment)((Object)this.removeEmptyParamVisitor.visitDocComment(docComment, executionContext));
                        }
                        return it;
                    }));
                }
                return md;
            }

            class RemoveEmptyParamVisitor
            extends JavadocVisitor<ExecutionContext> {
                public RemoveEmptyParamVisitor() {
                    super(new JavaIsoVisitor());
                }

                @Override
                public Javadoc visitDocComment(Javadoc.DocComment javadoc, ExecutionContext executionContext) {
                    ArrayList<Javadoc> newBody = new ArrayList<Javadoc>(javadoc.getBody().size());
                    boolean useNewBody = false;
                    List<Javadoc> body = javadoc.getBody();
                    for (int i = 0; i < body.size(); ++i) {
                        Javadoc currentDoc = body.get(i);
                        boolean skipCurrentDoc = false;
                        if (i + 1 < body.size()) {
                            Javadoc.Erroneous erroneous;
                            Javadoc nextDoc = body.get(i + 1);
                            if (nextDoc instanceof Javadoc.Parameter) {
                                Javadoc.Parameter parameter = (Javadoc.Parameter)this.visitParameter((Javadoc.Parameter)nextDoc, executionContext);
                                if (parameter == null) {
                                    if (i + 1 == body.size() - 1) {
                                        newBody.add(((Javadoc.Parameter)body.get(i + 1)).getDescription().get(0));
                                    }
                                    ++i;
                                    useNewBody = true;
                                    skipCurrentDoc = true;
                                }
                            } else if (nextDoc instanceof Javadoc.Return) {
                                Javadoc.Return aReturn = (Javadoc.Return)this.visitReturn((Javadoc.Return)nextDoc, executionContext);
                                if (aReturn == null) {
                                    if (!newBody.isEmpty() && newBody.get(newBody.size() - 1) instanceof Javadoc.LineBreak) {
                                        newBody.remove(newBody.size() - 1);
                                    }
                                    if (i + 1 == body.size() - 1) {
                                        newBody.add(((Javadoc.Return)body.get(i + 1)).getDescription().get(0));
                                    }
                                    ++i;
                                    useNewBody = true;
                                    skipCurrentDoc = true;
                                }
                            } else if (nextDoc instanceof Javadoc.Erroneous && (erroneous = (Javadoc.Erroneous)this.visitErroneous((Javadoc.Erroneous)nextDoc, executionContext)) == null) {
                                if (!newBody.isEmpty() && newBody.get(newBody.size() - 1) instanceof Javadoc.LineBreak) {
                                    newBody.remove(newBody.size() - 1);
                                }
                                ++i;
                                useNewBody = true;
                                skipCurrentDoc = true;
                            }
                        }
                        if (skipCurrentDoc) continue;
                        newBody.add(currentDoc);
                    }
                    if (useNewBody) {
                        javadoc = javadoc.withBody(newBody);
                    }
                    return super.visitDocComment(javadoc, executionContext);
                }

                @Override
                public Javadoc visitParameter(Javadoc.Parameter parameter, ExecutionContext executionContext) {
                    if (parameter.getDescription().stream().allMatch(it -> it instanceof Javadoc.LineBreak)) {
                        return null;
                    }
                    return super.visitParameter(parameter, executionContext);
                }

                @Override
                public Javadoc visitReturn(Javadoc.Return aReturn, ExecutionContext executionContext) {
                    if (aReturn.getDescription().stream().allMatch(it -> it instanceof Javadoc.LineBreak)) {
                        return null;
                    }
                    return super.visitReturn(aReturn, executionContext);
                }

                @Override
                public Javadoc visitErroneous(Javadoc.Erroneous erroneous, ExecutionContext executionContext) {
                    Javadoc.Text text;
                    if (erroneous.getText().size() == 1 && erroneous.getText().get(0) instanceof Javadoc.Text && "@throws".equals((text = (Javadoc.Text)erroneous.getText().get(0)).getText())) {
                        return null;
                    }
                    return super.visitErroneous(erroneous, executionContext);
                }
            }
        };
    }
}

