/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.TypeUtils;

public class AvoidBoxedBooleanExpressions
extends Recipe {
    public String getDisplayName() {
        return "Avoid boxed boolean expressions";
    }

    public String getDescription() {
        return "Under certain conditions the `java.lang.Boolean` type is used as an expression, and it may throw a `NullPointerException` if the value is null.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-5411");
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType<ExecutionContext>("java.lang.Boolean");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.of(5L, ChronoUnit.MINUTES);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            public Expression visitExpression(Expression expression, ExecutionContext ctx) {
                Expression e = (Expression)super.visitExpression(expression, ctx);
                if (TypeUtils.isOfClassType(e.getType(), "java.lang.Boolean") && this.isControlExpression(expression)) {
                    return (Expression)e.withTemplate(JavaTemplate.builder(() -> (this).getCursor(), "Boolean.TRUE.equals(#{any(java.lang.Boolean)})").build(), e.getCoordinates().replace(), e);
                }
                return e;
            }

            @Override
            public J visitUnary(J.Unary unary, ExecutionContext executionContext) {
                J.Unary un = (J.Unary)super.visitUnary(unary, executionContext);
                if (J.Unary.Type.Not == un.getOperator() && TypeUtils.isOfClassType(un.getExpression().getType(), "java.lang.Boolean")) {
                    return un.withTemplate(JavaTemplate.builder(() -> (this).getCursor(), "Boolean.FALSE.equals(#{any(java.lang.Boolean)})").build(), un.getCoordinates().replace(), un.getExpression());
                }
                return un;
            }

            private boolean isControlExpression(Expression expression) {
                Cursor parentCursor = this.getCursor().getParentTreeCursor();
                if (parentCursor.getValue() instanceof J.ControlParentheses && parentCursor.getParentTreeCursor().getValue() instanceof J.If) {
                    return true;
                }
                if (parentCursor.getValue() instanceof J.Ternary) {
                    return ((J.Ternary)parentCursor.getValue()).getCondition() == expression;
                }
                return false;
            }
        };
    }
}

