/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.J;

public class JavaParserResolver
implements ParameterResolver {
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> paramType = parameterContext.getParameter().getType();
        return paramType.equals(JavaParser.class) || paramType.equals(JavaParser.Builder.class);
    }

    @Nullable
    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Object o = extensionContext.getTestInstance().get();
        try {
            Class<?> clazz = o.getClass();
            Object target = o;
            do {
                try {
                    J.clearCaches();
                    Method javaParser = clazz.getMethod("javaParser", new Class[0]);
                    javaParser.setAccessible(true);
                    Class<?> paramType = parameterContext.getParameter().getType();
                    Object param = javaParser.invoke(target, new Object[0]);
                    if (paramType.equals(JavaParser.Builder.class)) {
                        return param;
                    }
                    if (paramType.equals(JavaParser.class)) {
                        return ((JavaParser.Builder)((Object)param)).build();
                    }
                }
                catch (NoSuchMethodException javaParser) {
                    // empty catch block
                }
                try {
                    target = o.getClass().getDeclaredField("this$0").get(target);
                }
                catch (NoSuchFieldException e) {
                    break;
                }
            } while ((clazz = clazz.getEnclosingClass()) != null);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        Assertions.fail((String)"This should never happen -- an implementation of javaParser() was not found");
        return null;
    }
}

