/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.WrappingAndBracesVisitor;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.WrappingAndBracesStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;

public class WrappingAndBraces
extends Recipe {
    public String getDisplayName() {
        return "Wrapping and braces";
    }

    public String getDescription() {
        return "Format line wraps and braces in Java code.";
    }

    public Set<String> getTags() {
        return new LinkedHashSet<String>(Arrays.asList("RSPEC-121", "RSPEC-2681", "RSPEC-3972", "RSPEC-3973"));
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(10L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new WrappingAndBracesCompilationUnitStyle();
    }

    public static <J2 extends J> J2 formatWrappingAndBraces(J j, Cursor cursor) {
        WrappingAndBracesStyle style = (WrappingAndBracesStyle)((SourceFile)cursor.firstEnclosingOrThrow(SourceFile.class)).getStyle(WrappingAndBracesStyle.class);
        return (J2)((J)new WrappingAndBracesVisitor(style == null ? IntelliJ.wrappingAndBraces() : style).visitNonNull(j, 0, cursor));
    }

    private static class WrappingAndBracesCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private WrappingAndBracesCompilationUnitStyle() {
        }

        @Override
        public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext ctx) {
            WrappingAndBracesStyle style = (WrappingAndBracesStyle)((SourceFile)cu).getStyle(WrappingAndBracesStyle.class);
            if (style == null) {
                style = IntelliJ.wrappingAndBraces();
            }
            this.doAfterVisit(new WrappingAndBracesVisitor(style));
            return cu;
        }
    }
}

