/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;

public final class ExplicitCharsetOnStringGetBytes
extends Recipe {
    private static final MethodMatcher GET_BYTES = new MethodMatcher("java.lang.String getBytes()");
    @Option(displayName="Default encoding", description="The default encoding to supply to the `getBytes` call.", example="UTF_8", required=false)
    @Nullable
    private final String encoding;

    public String getDisplayName() {
        return "Set charset encoding explicitly when calling `String#getBytes`. This will not override any existing explicit encodings, even if they don't match the default encoding option.";
    }

    public String getDescription() {
        return "This makes the behavior of the code platform neutral.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod<ExecutionContext>(GET_BYTES);
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            final JavaTemplate WITH_ENCODING = JavaTemplate.builder(() -> (this).getCursor(), "getBytes(StandardCharsets.#{})").imports("java.nio.charset.StandardCharsets").build();

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J m = super.visitMethodInvocation(method, ctx);
                if (GET_BYTES.matches(method)) {
                    this.maybeAddImport("java.nio.charset.StandardCharsets");
                    m = (J.MethodInvocation)m.withTemplate(this.WITH_ENCODING, method.getCoordinates().replaceMethod(), ExplicitCharsetOnStringGetBytes.this.encoding == null ? "UTF_8" : ExplicitCharsetOnStringGetBytes.this.encoding);
                }
                return m;
            }
        };
    }

    public ExplicitCharsetOnStringGetBytes(@Nullable String encoding) {
        this.encoding = encoding;
    }

    @Nullable
    public String getEncoding() {
        return this.encoding;
    }

    @NonNull
    public String toString() {
        return "ExplicitCharsetOnStringGetBytes(encoding=" + this.getEncoding() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExplicitCharsetOnStringGetBytes)) {
            return false;
        }
        ExplicitCharsetOnStringGetBytes other = (ExplicitCharsetOnStringGetBytes)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$encoding = this.getEncoding();
        String other$encoding = other.getEncoding();
        return !(this$encoding == null ? other$encoding != null : !this$encoding.equals(other$encoding));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ExplicitCharsetOnStringGetBytes;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $encoding = this.getEncoding();
        result = result * 59 + ($encoding == null ? 43 : $encoding.hashCode());
        return result;
    }
}

