/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.plugins;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.plugins.RemovePluginVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public final class RemoveBuildPlugin
extends Recipe {
    @Option(displayName="Plugin id", description="The plugin id to remove.", example="com.jfrog.bintray")
    private final String pluginId;

    public String getDisplayName() {
        return "Remove Gradle plugin";
    }

    public String getDescription() {
        return "Remove plugin from Gradle `plugins` block by its id. Does not remove plugins from the `buildscript` block.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new IsBuildGradle(), (TreeVisitor)new RemovePluginVisitor(this.pluginId));
    }

    public RemoveBuildPlugin(String pluginId) {
        this.pluginId = pluginId;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    @NonNull
    public String toString() {
        return "RemoveBuildPlugin(pluginId=" + this.getPluginId() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveBuildPlugin)) {
            return false;
        }
        RemoveBuildPlugin other = (RemoveBuildPlugin)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        return !(this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveBuildPlugin;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        return result;
    }
}

