/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;

public class SimplifyDurationCreationUnits
extends Recipe {
    public String getDisplayName() {
        return "Simplify `java.time.Duration` units";
    }

    public String getDescription() {
        return "Simplifies `java.time.Duration` units to be more human-readable.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod("java.time.Duration of*(long)"), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                method = super.visitMethodInvocation(method, (Object)ctx);
                DurationUnits invocationUnits = null;
                for (DurationUnits maybeUnit : DurationUnits.values()) {
                    if (!maybeUnit.methodMatcher.matches((MethodCall)method)) continue;
                    invocationUnits = maybeUnit;
                    break;
                }
                if (invocationUnits == null) {
                    return method;
                }
                Long invocationUnitCount = SimplifyDurationCreationUnits.getConstantIntegralValue((Expression)method.getArguments().get(0));
                if (invocationUnitCount == null || invocationUnitCount == 0L) {
                    return method;
                }
                long millis = invocationUnitCount * invocationUnits.millisFactor;
                DurationUnits simplifiedUnits = null;
                for (DurationUnits maybeUnit : DurationUnits.values()) {
                    if (millis % maybeUnit.millisFactor != 0L) continue;
                    simplifiedUnits = maybeUnit;
                    break;
                }
                if (simplifiedUnits == null || simplifiedUnits == invocationUnits) {
                    return method;
                }
                JavaTemplate template = JavaTemplate.builder((String)"#{}(#{})").contextSensitive().build();
                return (J.MethodInvocation)this.maybeAutoFormat((J)method, (J)((J.MethodInvocation)template.apply(this.updateCursor((Tree)method), method.getCoordinates().replaceMethod(), new Object[]{simplifiedUnits.methodName, millis / simplifiedUnits.millisFactor})), ctx);
            }
        });
    }

    public static @Nullable Long getConstantIntegralValue(Expression expression) {
        if (expression instanceof J.Literal) {
            J.Literal literal = (J.Literal)expression;
            if (literal.getType() != JavaType.Primitive.Int && literal.getType() != JavaType.Primitive.Long) {
                return null;
            }
            Object value = literal.getValue();
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
        } else if (expression instanceof J.Binary) {
            J.Binary binary = (J.Binary)expression;
            if (binary.getOperator() != J.Binary.Type.Multiplication) {
                return null;
            }
            Long left = SimplifyDurationCreationUnits.getConstantIntegralValue(binary.getLeft());
            if (left == null) {
                return null;
            }
            Long right = SimplifyDurationCreationUnits.getConstantIntegralValue(binary.getRight());
            if (right == null) {
                return null;
            }
            return left * right;
        }
        return null;
    }

    private static enum DurationUnits {
        DAYS("ofDays", ChronoUnit.DAYS),
        HOURS("ofHours", ChronoUnit.HOURS),
        MINUTES("ofMinutes", ChronoUnit.MINUTES),
        SECONDS("ofSeconds", ChronoUnit.SECONDS),
        MILLIS("ofMillis", ChronoUnit.MILLIS);

        final String methodName;
        final long millisFactor;
        final MethodMatcher methodMatcher;

        private DurationUnits(String methodName, TemporalUnit unit) {
            this.methodName = methodName;
            this.millisFactor = Duration.of(1L, unit).toMillis();
            this.methodMatcher = new MethodMatcher("java.time.Duration " + methodName + "(long)");
        }
    }
}

