/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;

public class ReplaceClassIsInstanceWithInstanceof
extends Recipe {
    private static final MethodMatcher ISINSTANCE_MATCHER = new MethodMatcher("java.lang.Class isInstance(..)");

    public String getDisplayName() {
        return "Replace `A.class.isInstance(a)` with `a instanceof A`";
    }

    public String getDescription() {
        return "There should be no `A.class.isInstance(a)`, it should be replaced by `a instanceof A`.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S6202");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(ISINSTANCE_MATCHER), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (ISINSTANCE_MATCHER.matches((MethodCall)method) && this.isObjectClass(method.getSelect())) {
                    Expression objectExpression = (Expression)method.getArguments().get(0);
                    J.FieldAccess fieldAccessPart = (J.FieldAccess)method.getSelect();
                    JavaCoordinates coordinates = method.getCoordinates().replace();
                    J.InstanceOf instanceOf = (J.InstanceOf)JavaTemplate.builder((String)"#{any()} instanceof Object").build().apply(this.getCursor(), coordinates, new Object[]{objectExpression});
                    instanceOf = instanceOf.withClazz(fieldAccessPart.getTarget().withPrefix(instanceOf.getClazz().getPrefix()));
                    return this.maybeAutoFormat((J)method, (J)instanceOf, ctx);
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }

            private boolean isObjectClass(@Nullable Expression expression) {
                J.FieldAccess fieldAccess;
                if (expression instanceof J.FieldAccess && (fieldAccess = (J.FieldAccess)expression).getName().getSimpleName().equals("class") && fieldAccess.getTarget() instanceof J.Identifier) {
                    J.Identifier identifier = (J.Identifier)fieldAccess.getTarget();
                    return identifier.getType() instanceof JavaType.Class;
                }
                return false;
            }
        });
    }
}

