/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.staticanalysis.ChainStringBuilderAppendCalls;

public class ReplaceDeprecatedRuntimeExecMethods
extends Recipe {
    private static final MethodMatcher RUNTIME_EXEC_CMD = new MethodMatcher("java.lang.Runtime exec(String)");
    private static final MethodMatcher RUNTIME_EXEC_CMD_ENVP = new MethodMatcher("java.lang.Runtime exec(String, String[])");
    private static final MethodMatcher RUNTIME_EXEC_CMD_ENVP_FILE = new MethodMatcher("java.lang.Runtime exec(String, String[], java.io.File)");

    public String getDisplayName() {
        return "Replace deprecated `Runtime#exec()` methods";
    }

    public String getDescription() {
        return "Replace `Runtime#exec(String)` methods to use `exec(String[])` instead because the former is deprecated after Java 18 and is no longer recommended for use by the Java documentation.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(3L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesJavaVersion(18), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)executionContext);
                if (RUNTIME_EXEC_CMD.matches((MethodCall)m) || RUNTIME_EXEC_CMD_ENVP.matches((MethodCall)m) || RUNTIME_EXEC_CMD_ENVP_FILE.matches((MethodCall)m)) {
                    Expression command = (Expression)m.getArguments().get(0);
                    ArrayList<Expression> commands = new ArrayList<Expression>();
                    boolean flattenAble = ChainStringBuilderAppendCalls.flatAdditiveExpressions(command, commands);
                    StringBuilder sb = new StringBuilder();
                    if (flattenAble) {
                        for (Expression e : commands) {
                            if (e instanceof J.Literal && ((J.Literal)e).getType() == JavaType.Primitive.String) {
                                sb.append(((J.Literal)e).getValue());
                                continue;
                            }
                            flattenAble = false;
                            break;
                        }
                    }
                    this.updateCursor((Tree)m);
                    if (flattenAble) {
                        String[] cmds = sb.toString().split(" ");
                        String templateCode = String.format("new String[] {%s}", ReplaceDeprecatedRuntimeExecMethods.toStringArguments(cmds));
                        JavaTemplate template = JavaTemplate.builder((String)templateCode).build();
                        List args = m.getArguments();
                        Cursor cursor = new Cursor(this.getCursor(), args.get(0));
                        args.set(0, (Expression)template.apply(cursor, ((Expression)args.get(0)).getCoordinates().replace(), new Object[0]));
                        if (m.getMethodType() != null) {
                            List parameterTypes = m.getMethodType().getParameterTypes();
                            parameterTypes.set(0, JavaType.ShallowClass.build((String)"java.lang.String[]"));
                            return m.withArguments(args).withMethodType(m.getMethodType().withParameterTypes(parameterTypes));
                        }
                    } else {
                        List args = m.getArguments();
                        boolean needWrap = false;
                        Expression arg0 = (Expression)args.get(0);
                        if (!(arg0 instanceof J.Identifier || arg0 instanceof J.Literal || arg0 instanceof J.MethodInvocation)) {
                            needWrap = true;
                        }
                        String code = needWrap ? "(#{any()}).split(\" \")" : "#{any()}.split(\" \")";
                        JavaTemplate template = JavaTemplate.builder((String)code).contextSensitive().build();
                        Cursor cursor = new Cursor(this.getCursor(), args.get(0));
                        arg0 = (Expression)template.apply(cursor, ((Expression)args.get(0)).getCoordinates().replace(), new Object[]{args.get(0)});
                        args.set(0, arg0);
                        if (m.getMethodType() != null) {
                            List parameterTypes = m.getMethodType().getParameterTypes();
                            parameterTypes.set(0, JavaType.ShallowClass.build((String)"java.lang.String[]"));
                            return m.withArguments(args).withMethodType(m.getMethodType().withParameterTypes(parameterTypes));
                        }
                        return m;
                    }
                }
                return m;
            }
        });
    }

    private static String toStringArguments(String[] cmds) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < cmds.length; ++i) {
            String token = cmds[i];
            if (i != 0) {
                sb.append(", ");
            }
            sb.append("\"").append(token).append("\"");
        }
        return sb.toString();
    }
}

