/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.quarkus.quarkus2;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.ChangeMethodTargetToStatic;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class UsePanacheEntityBaseStaticMethods
extends Recipe {
    private static final MethodMatcher GET_ENTITY_MANAGER = new MethodMatcher("io.quarkus.hibernate.orm.panache.PanacheEntityBase getEntityManager()");
    private static final MethodMatcher FLUSH = new MethodMatcher("io.quarkus.hibernate.orm.panache.PanacheEntityBase flush()");

    public String getDisplayName() {
        return "Use `PanacheEntityBase` static methods";
    }

    public String getDescription() {
        return "The `getEntityManager()` and the `flush()` methods of `PanacheEntityBase` are now static methods.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(GET_ENTITY_MANAGER), new UsesMethod(FLUSH)}), (TreeVisitor)new UsePanacheEntityBaseStaticMethodsVisitor());
    }

    private static class UsePanacheEntityBaseStaticMethodsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private UsePanacheEntityBaseStaticMethodsVisitor() {
        }

        @Nullable
        private static String getSelectTypeFQ(J.MethodInvocation method) {
            JavaType.FullyQualified selectType;
            if (method.getSelect() != null && (selectType = TypeUtils.asFullyQualified((JavaType)method.getSelect().getType())) != null) {
                return selectType.getFullyQualifiedName();
            }
            return null;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            String selectType;
            if (GET_ENTITY_MANAGER.matches((MethodCall)method)) {
                String selectType2 = UsePanacheEntityBaseStaticMethodsVisitor.getSelectTypeFQ(method);
                if (selectType2 != null) {
                    this.doAfterVisit(new ChangeMethodTargetToStatic("io.quarkus.hibernate.orm.panache.PanacheEntityBase getEntityManager()", selectType2, null, null).getVisitor());
                }
            } else if (FLUSH.matches((MethodCall)method) && (selectType = UsePanacheEntityBaseStaticMethodsVisitor.getSelectTypeFQ(method)) != null) {
                this.doAfterVisit(new ChangeMethodTargetToStatic("io.quarkus.hibernate.orm.panache.PanacheEntityBase flush()", selectType, null, null).getVisitor());
            }
            return super.visitMethodInvocation(method, (Object)ctx);
        }
    }
}

