/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.util;

import java.util.Collections;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.NoMissingTypes;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;

public class MigrateCollectionsSingletonList
extends Recipe {
    private static final MethodMatcher SINGLETON_LIST = new MethodMatcher("java.util.Collections singletonList(..)", true);

    public String getDisplayName() {
        return "Prefer `List.of(..)`";
    }

    public String getDescription() {
        return "Prefer `List.of(..)` instead of using `Collections.singletonList()` in Java 9 or higher.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor check = Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(9), new UsesMethod(SINGLETON_LIST), new NoMissingTypes()});
        return Preconditions.check((TreeVisitor)check, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (SINGLETON_LIST.matches((MethodCall)m) && !J.Literal.isLiteralValue((Expression)((Expression)m.getArguments().get(0)), null)) {
                    this.maybeRemoveImport("java.util.Collections");
                    this.maybeAddImport("java.util.List");
                    JavaType.ShallowClass classType = JavaType.ShallowClass.build((String)"java.util.List");
                    JavaType.Method methodType = m.getMethodType().withName("of").withDeclaringType((JavaType.FullyQualified)classType);
                    m = m.withName(m.getName().withSimpleName("of").withType((JavaType)methodType));
                    if (m.getSelect() instanceof J.Identifier) {
                        return m.withSelect((Expression)((J.Identifier)m.getSelect()).withSimpleName("List").withType((JavaType)classType));
                    }
                    return m.withSelect((Expression)new J.Identifier(Tree.randomId(), m.getPrefix(), m.getMarkers(), Collections.emptyList(), "List", (JavaType)classType, null)).withPrefix(Space.EMPTY);
                }
                return m;
            }
        });
    }
}

