/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

class SwitchUtils {
    SwitchUtils() {
    }

    public static boolean coversAllPossibleValues(J.Switch switch_) {
        JavaType.Class javaTypeClass;
        ArrayList<J> labels = new ArrayList<J>();
        for (Statement statement : switch_.getCases().getStatements()) {
            for (J j : ((J.Case)statement).getCaseLabels()) {
                if (j instanceof J.Identifier && "default".equals(((J.Identifier)j).getSimpleName())) {
                    return true;
                }
                labels.add(j);
            }
        }
        JavaType javaType = ((Expression)switch_.getSelector().getTree()).getType();
        if (javaType instanceof JavaType.Class && (javaTypeClass = (JavaType.Class)javaType).hasFlags(new Flag[]{Flag.Enum})) {
            Collection labelValues = labels.stream().filter(label -> label instanceof J.Identifier || label instanceof J.FieldAccess).filter(label -> TypeUtils.isOfType((JavaType)((TypeTree)label).getType(), (JavaType)javaType)).map(label -> label instanceof J.Identifier ? ((J.Identifier)label).getSimpleName() : ((J.FieldAccess)label).getName().getSimpleName()).collect(Collectors.toSet());
            if (labelValues.isEmpty()) {
                return false;
            }
            Collection enumValues = javaTypeClass.getMembers().stream().filter(member -> member.hasFlags(new Flag[]{Flag.Enum})).map(JavaType.Variable::getName).collect(Collectors.toSet());
            return !enumValues.isEmpty() && labelValues.containsAll(enumValues);
        }
        return false;
    }
}

