/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.micrometer.misk;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.Semantics;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class MigrateEmptyLabelMiskCounter
extends Recipe {
    public String getDisplayName() {
        return "Migrate Misk counter to Micrometer";
    }

    public String getDescription() {
        return "Convert a Misk (Prometheus) counter to a Micrometer counter.";
    }

    public List<Recipe> getRecipeList() {
        return super.getRecipeList();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("misk.metrics.v2.Metrics", Boolean.valueOf(true)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            final MethodMatcher miskCounter = new MethodMatcher("misk.metrics.v2.Metrics counter(..)");
            final MethodMatcher listOf = new MethodMatcher("kotlin.collections.CollectionsKt listOf()", true);

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (this.miskCounter.matches((MethodCall)method)) {
                    boolean emptyLabel;
                    boolean bl = emptyLabel = method.getArguments().size() == 2;
                    if (method.getArguments().size() == 3 && method.getArguments().get(2) instanceof J.MethodInvocation) {
                        JavaType.Method arg2 = ((J.MethodInvocation)method.getArguments().get(2)).getMethodType();
                        boolean bl2 = emptyLabel = arg2 != null && TypeUtils.isOfClassType((JavaType)arg2.getDeclaringType(), (String)"kotlin.collections.CollectionsKt") && arg2.getName().equals("listOf");
                    }
                    if (!emptyLabel) {
                        return m;
                    }
                    m = (J.MethodInvocation)Semantics.expression((JavaVisitor)this, (String)"micrometerCounter", (name, help) -> Counter.builder((String)name).description(help).register((MeterRegistry)Metrics.globalRegistry)).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getArguments().get(0), method.getArguments().get(1)});
                    this.maybeRemoveImport("misk.metrics.v2.Metrics");
                    this.maybeAddImport("io.micrometer.core.instrument.Counter");
                }
                return m;
            }
        });
    }
}

