/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.jackson;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.yaml.ChangePropertyValue;
import org.openrewrite.yaml.DeleteProperty;

public final class RemoveRedundantFeatureFlags
extends Recipe {
    private static final String OBJECT_MAPPER_TYPE = "com.fasterxml.jackson.databind.ObjectMapper";
    private static final MethodMatcher ENABLE_MATCHER = new MethodMatcher("com.fasterxml.jackson.databind.ObjectMapper enable(..)");
    private static final MethodMatcher DISABLE_MATCHER = new MethodMatcher("com.fasterxml.jackson.databind.ObjectMapper disable(..)");
    private static final MethodMatcher CONFIGURE_MATCHER = new MethodMatcher("com.fasterxml.jackson.databind.ObjectMapper configure(..)");
    @Option(displayName="Feature name", description="The fully qualified feature flag name that has a new default in Jackson 3. Format: `ClassName.FEATURE_NAME` (e.g., `MapperFeature.SORT_PROPERTIES_ALPHABETICALLY`).", example="MapperFeature.SORT_PROPERTIES_ALPHABETICALLY")
    private final String featureName;
    @Option(displayName="New default value", description="The new default boolean value for this feature flag in Jackson 3.", example="true")
    private final Boolean newDefaultValue;

    public String getDisplayName() {
        return "Remove redundant Jackson 3 feature flag configurations";
    }

    public String getDescription() {
        return "Remove `ObjectMapper` feature flag configurations that set values to their new Jackson 3 defaults. For example, `disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)` and `configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)` are redundant since this is now disabled by default in Jackson 3.";
    }

    public Set<String> getTags() {
        return Collections.singleton("jackson-3");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree preVisit(Tree tree, ExecutionContext ctx) {
                this.stopAfterPreVisit();
                if (tree instanceof SourceFile) {
                    SourceFile sourceFile = (SourceFile)tree;
                    TreeVisitor javaVisitor = RemoveRedundantFeatureFlags.this.javaVisitor();
                    if (javaVisitor.isAcceptable(sourceFile, (Object)ctx)) {
                        return javaVisitor.visitNonNull(tree, (Object)ctx);
                    }
                    TreeVisitor propertiesVisitor = RemoveRedundantFeatureFlags.this.propertiesVisitor();
                    if (propertiesVisitor.isAcceptable(sourceFile, (Object)ctx)) {
                        return propertiesVisitor.visitNonNull(tree, (Object)ctx);
                    }
                    TreeVisitor yamlVisitor = RemoveRedundantFeatureFlags.this.yamlVisitor();
                    if (yamlVisitor.isAcceptable(sourceFile, (Object)ctx)) {
                        return yamlVisitor.visitNonNull(tree, (Object)ctx);
                    }
                }
                return tree;
            }
        };
    }

    private TreeVisitor<?, ExecutionContext> javaVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(ENABLE_MATCHER), new UsesMethod(DISABLE_MATCHER), new UsesMethod(CONFIGURE_MATCHER)}), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public @Nullable J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (this.shouldRemove(method)) {
                    return method.getSelect() instanceof J.MethodInvocation ? method.getSelect() : null;
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }

            private boolean shouldRemove(J.MethodInvocation mi) {
                if (ENABLE_MATCHER.matches((MethodCall)mi)) {
                    return RemoveRedundantFeatureFlags.this.newDefaultValue != false && RemoveRedundantFeatureFlags.this.featureName.equals(this.getFeatureNameFromArg((Expression)mi.getArguments().get(0)));
                }
                if (DISABLE_MATCHER.matches((MethodCall)mi)) {
                    return RemoveRedundantFeatureFlags.this.newDefaultValue == false && RemoveRedundantFeatureFlags.this.featureName.equals(this.getFeatureNameFromArg((Expression)mi.getArguments().get(0)));
                }
                if (CONFIGURE_MATCHER.matches((MethodCall)mi)) {
                    return mi.getArguments().size() == 2 && J.Literal.isLiteralValue((Expression)((Expression)mi.getArguments().get(1)), (Object)RemoveRedundantFeatureFlags.this.newDefaultValue) && RemoveRedundantFeatureFlags.this.featureName.equals(this.getFeatureNameFromArg((Expression)mi.getArguments().get(0)));
                }
                return false;
            }

            private @Nullable String getFeatureNameFromArg(Expression arg) {
                J.Identifier identifier;
                if (arg instanceof J.FieldAccess) {
                    J.FieldAccess fieldAccess = (J.FieldAccess)arg;
                    if (fieldAccess.getTarget() instanceof J.Identifier) {
                        String className = ((J.Identifier)fieldAccess.getTarget()).getSimpleName();
                        String fieldName = fieldAccess.getName().getSimpleName();
                        return className + "." + fieldName;
                    }
                } else if (arg instanceof J.Identifier && (identifier = (J.Identifier)arg).getFieldType() != null && identifier.getFieldType().getOwner() instanceof JavaType.FullyQualified) {
                    JavaType.FullyQualified owner = (JavaType.FullyQualified)identifier.getFieldType().getOwner();
                    String fullyQualifiedName = owner.getFullyQualifiedName();
                    String className = fullyQualifiedName.substring(fullyQualifiedName.lastIndexOf(46) + 1);
                    String fieldName = identifier.getSimpleName();
                    return className + "." + fieldName;
                }
                return null;
            }
        });
    }

    private TreeVisitor<?, ExecutionContext> propertiesVisitor() {
        String propertyKey = "spring.jackson.mapper." + this.featureName.split("\\.")[1];
        return Preconditions.check((Recipe)new org.openrewrite.properties.ChangePropertyValue(propertyKey, String.valueOf(this.newDefaultValue == false), null, Boolean.valueOf(false), Boolean.valueOf(false)), (TreeVisitor)new org.openrewrite.properties.DeleteProperty(propertyKey, Boolean.valueOf(false)).getVisitor());
    }

    private TreeVisitor<?, ExecutionContext> yamlVisitor() {
        String propertyKey = "spring.jackson.mapper." + this.featureName.split("\\.")[1];
        return Preconditions.check((Recipe)new ChangePropertyValue(propertyKey, String.valueOf(this.newDefaultValue == false), null, Boolean.valueOf(false), Boolean.valueOf(false), null), (TreeVisitor)new DeleteProperty(propertyKey, Boolean.valueOf(false), null, null).getVisitor());
    }

    @ConstructorProperties(value={"featureName", "newDefaultValue"})
    @Generated
    public RemoveRedundantFeatureFlags(String featureName, Boolean newDefaultValue) {
        this.featureName = featureName;
        this.newDefaultValue = newDefaultValue;
    }

    @Generated
    public String getFeatureName() {
        return this.featureName;
    }

    @Generated
    public Boolean getNewDefaultValue() {
        return this.newDefaultValue;
    }

    @Generated
    public String toString() {
        return "RemoveRedundantFeatureFlags(featureName=" + this.getFeatureName() + ", newDefaultValue=" + this.getNewDefaultValue() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveRedundantFeatureFlags)) {
            return false;
        }
        RemoveRedundantFeatureFlags other = (RemoveRedundantFeatureFlags)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$newDefaultValue = this.getNewDefaultValue();
        Boolean other$newDefaultValue = other.getNewDefaultValue();
        if (this$newDefaultValue == null ? other$newDefaultValue != null : !((Object)this$newDefaultValue).equals(other$newDefaultValue)) {
            return false;
        }
        String this$featureName = this.getFeatureName();
        String other$featureName = other.getFeatureName();
        return !(this$featureName == null ? other$featureName != null : !this$featureName.equals(other$featureName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RemoveRedundantFeatureFlags;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $newDefaultValue = this.getNewDefaultValue();
        result = result * 59 + ($newDefaultValue == null ? 43 : ((Object)$newDefaultValue).hashCode());
        String $featureName = this.getFeatureName();
        result = result * 59 + ($featureName == null ? 43 : $featureName.hashCode());
        return result;
    }
}

