/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.table;

import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;

public class CallGraph
extends DataTable<Row> {
    public CallGraph(Recipe recipe) {
        super(recipe, "Method call graph", "Records method callers and the methods they invoke.");
    }

    public static enum ResourceAction {
        CALL,
        READ,
        WRITE;

    }

    public static enum ResourceType {
        METHOD,
        FIELD,
        CONSTRUCTOR;

    }

    public static final class Row {
        @Column(displayName="From class", description="The fully qualified name of the class from which the action is issued.")
        private final String fromClass;
        @Column(displayName="From name", description="The name of the method or scope from which the action is issued.")
        private final String fromName;
        @Column(displayName="From arguments", description="The argument types, if any, to the method or scope from which the action is issued. Expressed as a comma-separated list")
        private final String fromArguments;
        @Column(displayName="From type", description="The type of resource the action is being issued from.")
        private final ResourceType fromType;
        @Column(displayName="Action", description="The type of access being made to the resource.")
        private final ResourceAction action;
        @Column(displayName="To class", description="The fully-qualified name of the class containing the resource being accessed.")
        private final String toClass;
        @Column(displayName="To name", description="The name of the resource being accessed.")
        private final String toName;
        @Column(displayName="To arguments", description="The argument types, if any, to the resource being accessed. Expressed as a comma-separated list")
        private final String toArguments;
        @Column(displayName="To type", description="The type of resource being accessed.")
        private final ResourceType toType;
        @Column(displayName="Return type", description="The return type of the method.")
        private final String returnType;

        public Row(String fromClass, String fromName, String fromArguments, ResourceType fromType, ResourceAction action, String toClass, String toName, String toArguments, ResourceType toType, String returnType) {
            this.fromClass = fromClass;
            this.fromName = fromName;
            this.fromArguments = fromArguments;
            this.fromType = fromType;
            this.action = action;
            this.toClass = toClass;
            this.toName = toName;
            this.toArguments = toArguments;
            this.toType = toType;
            this.returnType = returnType;
        }

        public String getFromClass() {
            return this.fromClass;
        }

        public String getFromName() {
            return this.fromName;
        }

        public String getFromArguments() {
            return this.fromArguments;
        }

        public ResourceType getFromType() {
            return this.fromType;
        }

        public ResourceAction getAction() {
            return this.action;
        }

        public String getToClass() {
            return this.toClass;
        }

        public String getToName() {
            return this.toName;
        }

        public String getToArguments() {
            return this.toArguments;
        }

        public ResourceType getToType() {
            return this.toType;
        }

        public String getReturnType() {
            return this.returnType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$fromClass = this.getFromClass();
            String other$fromClass = other.getFromClass();
            if (this$fromClass == null ? other$fromClass != null : !this$fromClass.equals(other$fromClass)) {
                return false;
            }
            String this$fromName = this.getFromName();
            String other$fromName = other.getFromName();
            if (this$fromName == null ? other$fromName != null : !this$fromName.equals(other$fromName)) {
                return false;
            }
            String this$fromArguments = this.getFromArguments();
            String other$fromArguments = other.getFromArguments();
            if (this$fromArguments == null ? other$fromArguments != null : !this$fromArguments.equals(other$fromArguments)) {
                return false;
            }
            ResourceType this$fromType = this.getFromType();
            ResourceType other$fromType = other.getFromType();
            if (this$fromType == null ? other$fromType != null : !((Object)((Object)this$fromType)).equals((Object)other$fromType)) {
                return false;
            }
            ResourceAction this$action = this.getAction();
            ResourceAction other$action = other.getAction();
            if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
                return false;
            }
            String this$toClass = this.getToClass();
            String other$toClass = other.getToClass();
            if (this$toClass == null ? other$toClass != null : !this$toClass.equals(other$toClass)) {
                return false;
            }
            String this$toName = this.getToName();
            String other$toName = other.getToName();
            if (this$toName == null ? other$toName != null : !this$toName.equals(other$toName)) {
                return false;
            }
            String this$toArguments = this.getToArguments();
            String other$toArguments = other.getToArguments();
            if (this$toArguments == null ? other$toArguments != null : !this$toArguments.equals(other$toArguments)) {
                return false;
            }
            ResourceType this$toType = this.getToType();
            ResourceType other$toType = other.getToType();
            if (this$toType == null ? other$toType != null : !((Object)((Object)this$toType)).equals((Object)other$toType)) {
                return false;
            }
            String this$returnType = this.getReturnType();
            String other$returnType = other.getReturnType();
            return !(this$returnType == null ? other$returnType != null : !this$returnType.equals(other$returnType));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fromClass = this.getFromClass();
            result = result * 59 + ($fromClass == null ? 43 : $fromClass.hashCode());
            String $fromName = this.getFromName();
            result = result * 59 + ($fromName == null ? 43 : $fromName.hashCode());
            String $fromArguments = this.getFromArguments();
            result = result * 59 + ($fromArguments == null ? 43 : $fromArguments.hashCode());
            ResourceType $fromType = this.getFromType();
            result = result * 59 + ($fromType == null ? 43 : ((Object)((Object)$fromType)).hashCode());
            ResourceAction $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
            String $toClass = this.getToClass();
            result = result * 59 + ($toClass == null ? 43 : $toClass.hashCode());
            String $toName = this.getToName();
            result = result * 59 + ($toName == null ? 43 : $toName.hashCode());
            String $toArguments = this.getToArguments();
            result = result * 59 + ($toArguments == null ? 43 : $toArguments.hashCode());
            ResourceType $toType = this.getToType();
            result = result * 59 + ($toType == null ? 43 : ((Object)((Object)$toType)).hashCode());
            String $returnType = this.getReturnType();
            result = result * 59 + ($returnType == null ? 43 : $returnType.hashCode());
            return result;
        }

        public String toString() {
            return "CallGraph.Row(fromClass=" + this.getFromClass() + ", fromName=" + this.getFromName() + ", fromArguments=" + this.getFromArguments() + ", fromType=" + (Object)((Object)this.getFromType()) + ", action=" + (Object)((Object)this.getAction()) + ", toClass=" + this.getToClass() + ", toName=" + this.getToName() + ", toArguments=" + this.getToArguments() + ", toType=" + (Object)((Object)this.getToType()) + ", returnType=" + this.getReturnType() + ")";
        }
    }
}

