/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.StringJoiner;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.table.CallGraph;

public final class FindCallGraph
extends Recipe {
    private final transient CallGraph callGraph = new CallGraph(this);
    @Option(displayName="Include standard library", description="When enabled calls to methods in packages beginning with \"java\", \"groovy\", and \"kotlin\" will be included in the report. By default these are omitted.", required=false)
    private final boolean includeStdLib;

    public String getDisplayName() {
        return "Find call graph";
    }

    public String getDescription() {
        return "Produces a data table where each row represents a method call.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            final Set<JavaType.Method> methodsCalledInScope = Collections.newSetFromMap(new IdentityHashMap());
            final Set<JavaType.Method> methodsCalledInit = Collections.newSetFromMap(new IdentityHashMap());
            final Set<JavaType.Method> methodsCalledClassInit = Collections.newSetFromMap(new IdentityHashMap());
            boolean inInitializer;
            boolean inStaticInitializer;

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                for (Statement statement : classDecl.getBody().getStatements()) {
                    if (statement instanceof J.Block) {
                        J.Block block = (J.Block)statement;
                        if (block.isStatic()) {
                            this.inStaticInitializer = true;
                        } else {
                            this.inInitializer = true;
                        }
                    } else if (statement instanceof J.VariableDeclarations) {
                        J.VariableDeclarations variableDeclarations = (J.VariableDeclarations)statement;
                        if (variableDeclarations.getModifiers().stream().anyMatch(mod -> mod.getType() == J.Modifier.Type.Static)) {
                            this.inStaticInitializer = true;
                        } else {
                            this.inInitializer = true;
                        }
                    }
                    this.visit((Tree)statement, ctx);
                    this.inStaticInitializer = false;
                    this.inInitializer = false;
                }
                return classDecl;
            }

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
                this.methodsCalledInScope.clear();
                return m;
            }

            public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                this.recordCall(newClass.getMethodType(), ctx);
                return super.visitNewClass(newClass, (Object)ctx);
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                this.recordCall(method.getMethodType(), ctx);
                return super.visitMethodInvocation(method, (Object)ctx);
            }

            public J.MemberReference visitMemberReference(J.MemberReference memberRef, ExecutionContext ctx) {
                this.recordCall(memberRef.getMethodType(), ctx);
                return super.visitMemberReference(memberRef, (Object)ctx);
            }

            private void recordCall(@Nullable JavaType.Method method, ExecutionContext ctx) {
                if (method == null) {
                    return;
                }
                String fqn = method.getDeclaringType().getFullyQualifiedName();
                if (!FindCallGraph.this.includeStdLib && (fqn.startsWith("java.") || fqn.startsWith("groovy.") || fqn.startsWith("kotlin."))) {
                    return;
                }
                J.MethodDeclaration declaration = (J.MethodDeclaration)this.getCursor().firstEnclosing(J.MethodDeclaration.class);
                if (declaration == null) {
                    J.ClassDeclaration classDecl = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
                    if (classDecl != null && classDecl.getType() != null && this.isValidMethodCall(method) && (this.inInitializer && this.methodsCalledInit.add(method) || this.inStaticInitializer && this.methodsCalledClassInit.add(method))) {
                        FindCallGraph.this.callGraph.insertRow(ctx, this.row(classDecl.getType(), method));
                    }
                } else if (declaration.getMethodType() != null && this.methodsCalledInScope.add(method) && this.isValidMethodCall(declaration.getMethodType(), method)) {
                    FindCallGraph.this.callGraph.insertRow(ctx, this.row(declaration.getMethodType(), method));
                }
            }

            private CallGraph.Row row(JavaType.FullyQualified from, JavaType.Method to) {
                String fromName = this.inInitializer ? "<init>" : (this.inStaticInitializer ? "<clinit>" : "");
                return new CallGraph.Row(from.getFullyQualifiedName(), fromName, "", CallGraph.ResourceType.METHOD, CallGraph.ResourceAction.CALL, to.getDeclaringType().getFullyQualifiedName(), to.getName(), FindCallGraph.parameters(to), FindCallGraph.resourceType(to), FindCallGraph.returnType(to));
            }

            private CallGraph.Row row(JavaType.Method from, JavaType.Method to) {
                return new CallGraph.Row(from.getDeclaringType().getFullyQualifiedName(), from.getName(), FindCallGraph.parameters(from), FindCallGraph.resourceType(from), CallGraph.ResourceAction.CALL, to.getDeclaringType().getFullyQualifiedName(), to.getName(), FindCallGraph.parameters(to), FindCallGraph.resourceType(to), FindCallGraph.returnType(to));
            }

            private boolean isValidMethodCall(JavaType.Method to) {
                return this.isNotAnonymousClass(to.getDeclaringType().getFullyQualifiedName());
            }

            private boolean isValidMethodCall(JavaType.Method from, JavaType.Method to) {
                return this.isNotAnonymousClass(from.getDeclaringType().getFullyQualifiedName()) && this.isNotAnonymousClass(to.getDeclaringType().getFullyQualifiedName());
            }

            private boolean isNotAnonymousClass(String fqn) {
                if (fqn.contains("$")) {
                    for (String s : fqn.split("\\$")) {
                        try {
                            Integer.valueOf(s);
                            return false;
                        }
                        catch (NumberFormatException numberFormatException) {
                        }
                    }
                }
                return true;
            }
        };
    }

    private static String parameters(JavaType.Method method) {
        StringJoiner joiner = new StringJoiner(",");
        for (JavaType javaType : method.getParameterTypes()) {
            String string = javaType.toString();
            joiner.add(string);
        }
        return joiner.toString();
    }

    private static CallGraph.ResourceType resourceType(JavaType.Method method) {
        if (method.isConstructor()) {
            return CallGraph.ResourceType.CONSTRUCTOR;
        }
        return CallGraph.ResourceType.METHOD;
    }

    private static String returnType(JavaType.Method method) {
        return method.getReturnType().toString();
    }

    public FindCallGraph(boolean includeStdLib) {
        this.includeStdLib = includeStdLib;
    }

    public CallGraph getCallGraph() {
        return this.callGraph;
    }

    public boolean isIncludeStdLib() {
        return this.includeStdLib;
    }

    public String toString() {
        return "FindCallGraph(callGraph=" + (Object)((Object)this.getCallGraph()) + ", includeStdLib=" + this.isIncludeStdLib() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindCallGraph)) {
            return false;
        }
        FindCallGraph other = (FindCallGraph)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.isIncludeStdLib() == other.isIncludeStdLib();
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindCallGraph;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isIncludeStdLib() ? 79 : 97);
        return result;
    }
}

