/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.search;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.analysis.dataflow.DataFlowNode;
import org.openrewrite.analysis.dataflow.DataFlowSpec;
import org.openrewrite.analysis.dataflow.FindLocalFlowPaths;
import org.openrewrite.analysis.dataflow.TaintFlowSpec;
import org.openrewrite.analysis.trait.expr.Expr;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.table.MethodCalls;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.marker.SearchResult;

public final class FindMethods
extends Recipe {
    private final transient MethodCalls methodCalls = new MethodCalls((Recipe)this);
    @Option(displayName="Method pattern", description="A method pattern that is used to find matching method invocations.", example="java.util.List add(..)")
    private final String methodPattern;
    @Option(displayName="Match on overrides", description="When enabled, find methods that are overrides of the method pattern.", required=false)
    private final @Nullable Boolean matchOverrides;
    @Option(displayName="Show flow", description="When enabled, show the data or taint flow of the method invocation.", valid={"none", "data", "taint"}, required=false)
    private final @Nullable String flow;

    public String getDisplayName() {
        return "Find method usages";
    }

    public String getDescription() {
        return "Find method usages by pattern.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher methodMatcher = new MethodMatcher(this.methodPattern, this.matchOverrides);
        final boolean flowEnabled = !StringUtils.isBlank((String)this.flow) && !"none".equals(this.flow);
        return Preconditions.check((TreeVisitor)new UsesMethod(this.methodPattern, this.matchOverrides), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (methodMatcher.matches((MethodCall)method)) {
                    if (!flowEnabled) {
                        JavaSourceFile javaSourceFile = (JavaSourceFile)this.getCursor().firstEnclosing(JavaSourceFile.class);
                        if (javaSourceFile != null) {
                            FindMethods.this.methodCalls.insertRow(ctx, (Object)new MethodCalls.Row(javaSourceFile.getSourcePath().toString(), method.printTrimmed(this.getCursor()), method.getMethodType().getDeclaringType().getFullyQualifiedName(), method.getSimpleName(), method.getArguments().stream().map(Expression::getType).map(String::valueOf).collect(Collectors.joining(", "))));
                        }
                        m = (J.MethodInvocation)SearchResult.found((Tree)m);
                    } else {
                        this.doAfterVisit((TreeVisitor)new FindLocalFlowPaths(this.getFlowSpec(this.getCursor())));
                    }
                }
                return m;
            }

            public J.MemberReference visitMemberReference(J.MemberReference memberRef, ExecutionContext ctx) {
                J.MemberReference m = super.visitMemberReference(memberRef, (Object)ctx);
                if (methodMatcher.matches(m.getMethodType())) {
                    if (!flowEnabled) {
                        JavaSourceFile javaSourceFile = (JavaSourceFile)this.getCursor().firstEnclosing(JavaSourceFile.class);
                        if (javaSourceFile != null) {
                            FindMethods.this.methodCalls.insertRow(ctx, (Object)new MethodCalls.Row(javaSourceFile.getSourcePath().toString(), memberRef.printTrimmed(this.getCursor()), memberRef.getMethodType().getDeclaringType().getFullyQualifiedName(), memberRef.getMethodType().getName(), memberRef.getArguments().stream().map(Expression::getType).map(String::valueOf).collect(Collectors.joining(", "))));
                        }
                        m = m.withReference((J.Identifier)SearchResult.found((Tree)m.getReference()));
                    } else {
                        this.doAfterVisit((TreeVisitor)new FindLocalFlowPaths(this.getFlowSpec(this.getCursor())));
                    }
                }
                return m;
            }

            public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                J.NewClass n = super.visitNewClass(newClass, (Object)ctx);
                if (methodMatcher.matches((MethodCall)newClass)) {
                    if (!flowEnabled) {
                        JavaSourceFile javaSourceFile = (JavaSourceFile)this.getCursor().firstEnclosing(JavaSourceFile.class);
                        if (javaSourceFile != null) {
                            FindMethods.this.methodCalls.insertRow(ctx, (Object)new MethodCalls.Row(javaSourceFile.getSourcePath().toString(), newClass.printTrimmed(this.getCursor()), newClass.getType().toString(), "<constructor>", newClass.getArguments().stream().map(Expression::getType).map(String::valueOf).collect(Collectors.joining(", "))));
                        }
                        n = (J.NewClass)SearchResult.found((Tree)n);
                    } else {
                        this.doAfterVisit((TreeVisitor)new FindLocalFlowPaths(this.getFlowSpec(this.getCursor())));
                    }
                }
                return n;
            }

            private DataFlowSpec getFlowSpec(final Cursor srcCursor) {
                switch (FindMethods.this.flow) {
                    case "data": {
                        return new DataFlowSpec(){

                            @Override
                            public boolean isSource(DataFlowNode srcNode) {
                                return (Boolean)srcNode.asExpr().map(src -> (Boolean)Expr.viewOf(srcCursor).map(s -> s.equals(src)).toOption().orSome((Object)false)).orSome((Object)false);
                            }

                            @Override
                            public boolean isSink(DataFlowNode sinkNode) {
                                return true;
                            }
                        };
                    }
                    case "taint": {
                        return new TaintFlowSpec(){

                            @Override
                            public boolean isSource(DataFlowNode srcNode) {
                                return (Boolean)srcNode.asExpr().map(src -> (Boolean)Expr.viewOf(srcCursor).map(s -> s.equals(src)).toOption().orSome((Object)false)).orSome((Object)false);
                            }

                            @Override
                            public boolean isSink(DataFlowNode sinkNode) {
                                return true;
                            }
                        };
                    }
                }
                throw new IllegalStateException("Unknown flow: " + FindMethods.this.flow);
            }
        });
    }

    public static Set<J> find(J j, String methodPattern) {
        return FindMethods.find(j, methodPattern, false);
    }

    public static Set<J> find(J j, String methodPattern, boolean matchOverrides) {
        FindMethods findMethods = new FindMethods(methodPattern, matchOverrides, null);
        findMethods.methodCalls.setEnabled(false);
        return ((HashSet)TreeVisitor.collect(findMethods.getVisitor(), (Tree)j, new HashSet())).stream().filter(t -> t instanceof J.MethodInvocation || t instanceof J.MemberReference || t instanceof J.NewClass).map(J.class::cast).collect(Collectors.toSet());
    }

    public static Set<J.MethodDeclaration> findDeclaration(J j, String methodPattern) {
        return FindMethods.findDeclaration(j, methodPattern, false);
    }

    public static Set<J.MethodDeclaration> findDeclaration(J j, final String methodPattern, final boolean matchOverrides) {
        return ((HashSet)TreeVisitor.collect((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            final MethodMatcher methodMatcher;
            {
                this.methodMatcher = new MethodMatcher(methodPattern, matchOverrides);
            }

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.ClassDeclaration enclosingClass = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
                if (enclosingClass != null && this.methodMatcher.matches(method, (J.ClassDeclaration)this.getCursor().firstEnclosingOrThrow(J.ClassDeclaration.class))) {
                    return (J.MethodDeclaration)SearchResult.found((Tree)method);
                }
                if (this.methodMatcher.matches(method.getMethodType())) {
                    return (J.MethodDeclaration)SearchResult.found((Tree)method);
                }
                return super.visitMethodDeclaration(method, (Object)ctx);
            }
        }, (Tree)j, new HashSet())).stream().filter(J.MethodDeclaration.class::isInstance).map(J.MethodDeclaration.class::cast).collect(Collectors.toSet());
    }

    @Generated
    public FindMethods(String methodPattern, @Nullable Boolean matchOverrides, @Nullable String flow) {
        this.methodPattern = methodPattern;
        this.matchOverrides = matchOverrides;
        this.flow = flow;
    }

    @Generated
    public MethodCalls getMethodCalls() {
        return this.methodCalls;
    }

    @Generated
    public String getMethodPattern() {
        return this.methodPattern;
    }

    @Generated
    public @Nullable Boolean getMatchOverrides() {
        return this.matchOverrides;
    }

    @Generated
    public @Nullable String getFlow() {
        return this.flow;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindMethods(methodCalls=" + this.getMethodCalls() + ", methodPattern=" + this.getMethodPattern() + ", matchOverrides=" + this.getMatchOverrides() + ", flow=" + this.getFlow() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindMethods)) {
            return false;
        }
        FindMethods other = (FindMethods)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$matchOverrides = this.getMatchOverrides();
        Boolean other$matchOverrides = other.getMatchOverrides();
        if (this$matchOverrides == null ? other$matchOverrides != null : !((Object)this$matchOverrides).equals(other$matchOverrides)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
            return false;
        }
        String this$flow = this.getFlow();
        String other$flow = other.getFlow();
        return !(this$flow == null ? other$flow != null : !this$flow.equals(other$flow));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof FindMethods;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $matchOverrides = this.getMatchOverrides();
        result = result * 59 + ($matchOverrides == null ? 43 : ((Object)$matchOverrides).hashCode());
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        String $flow = this.getFlow();
        result = result * 59 + ($flow == null ? 43 : $flow.hashCode());
        return result;
    }
}

