/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.image.impl;

import com.sun.javafx.image.AlphaType;
import com.sun.javafx.image.BytePixelAccessor;
import com.sun.javafx.image.BytePixelGetter;
import com.sun.javafx.image.BytePixelSetter;
import com.sun.javafx.image.ByteToBytePixelConverter;
import com.sun.javafx.image.PixelUtils;
import com.sun.javafx.image.impl.BaseByteToByteConverter;
import com.sun.javafx.image.impl.ByteBgra;
import com.sun.javafx.image.impl.ByteBgraPre;
import java.nio.ByteBuffer;

public final class ByteAbgr {
    public static final BytePixelGetter getter = Accessor.instance;
    public static final BytePixelSetter setter = Accessor.instance;
    public static final BytePixelAccessor accessor = Accessor.instance;
    private static ByteToBytePixelConverter ToByteBgraObj;

    private ByteAbgr() {
    }

    public static ByteToBytePixelConverter ToByteBgraConverter() {
        if (ToByteBgraObj == null) {
            ToByteBgraObj = BaseByteToByteConverter.createReorderer(getter, ByteBgra.setter, 1, 2, 3, 0);
        }
        return ToByteBgraObj;
    }

    public static ByteToBytePixelConverter ToByteBgraPreConverter() {
        return ToByteBgraPreConv.instance;
    }

    static class ToByteBgraPreConv
    extends BaseByteToByteConverter {
        static final ByteToBytePixelConverter instance = new ToByteBgraPreConv();

        private ToByteBgraPreConv() {
            super(getter, ByteBgraPre.setter);
        }

        @Override
        void doConvert(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, int n5, int n6) {
            n2 -= n5 * 4;
            n4 -= n5 * 4;
            while (--n6 >= 0) {
                for (int i = 0; i < n5; ++i) {
                    int n7 = byArray[n] & 0xFF;
                    byte by = byArray[n + 1];
                    byte by2 = byArray[n + 2];
                    byte by3 = byArray[n + 3];
                    n += 4;
                    if (n7 < 255) {
                        if (n7 == 0) {
                            by3 = 0;
                            by2 = 0;
                            by = 0;
                        } else {
                            by = (byte)(((by & 0xFF) * n7 + 127) / 255);
                            by2 = (byte)(((by2 & 0xFF) * n7 + 127) / 255);
                            by3 = (byte)(((by3 & 0xFF) * n7 + 127) / 255);
                        }
                    }
                    byArray2[n3++] = by;
                    byArray2[n3++] = by2;
                    byArray2[n3++] = by3;
                    byArray2[n3++] = (byte)n7;
                }
                n += n2;
                n3 += n4;
            }
        }

        @Override
        void doConvert(ByteBuffer byteBuffer, int n, int n2, ByteBuffer byteBuffer2, int n3, int n4, int n5, int n6) {
            n2 -= n5 * 4;
            n4 -= n5 * 4;
            while (--n6 >= 0) {
                for (int i = 0; i < n5; ++i) {
                    int n7 = byteBuffer.get(n) & 0xFF;
                    byte by = byteBuffer.get(n + 1);
                    byte by2 = byteBuffer.get(n + 2);
                    byte by3 = byteBuffer.get(n + 3);
                    n += 4;
                    if (n7 < 255) {
                        if (n7 == 0) {
                            by3 = 0;
                            by2 = 0;
                            by = 0;
                        } else {
                            by = (byte)(((by & 0xFF) * n7 + 127) / 255);
                            by2 = (byte)(((by2 & 0xFF) * n7 + 127) / 255);
                            by3 = (byte)(((by3 & 0xFF) * n7 + 127) / 255);
                        }
                    }
                    byteBuffer2.put(n3, by);
                    byteBuffer2.put(n3 + 1, by2);
                    byteBuffer2.put(n3 + 2, by3);
                    byteBuffer2.put(n3 + 3, (byte)n7);
                    n3 += 4;
                }
                n += n2;
                n3 += n4;
            }
        }
    }

    static class Accessor
    implements BytePixelAccessor {
        static final BytePixelAccessor instance = new Accessor();

        private Accessor() {
        }

        @Override
        public AlphaType getAlphaType() {
            return AlphaType.NONPREMULTIPLIED;
        }

        @Override
        public int getNumElements() {
            return 4;
        }

        @Override
        public int getArgb(byte[] byArray, int n) {
            return byArray[n] << 24 | byArray[n + 1] & 0xFF | (byArray[n + 2] & 0xFF) << 8 | (byArray[n + 3] & 0xFF) << 16;
        }

        @Override
        public int getArgbPre(byte[] byArray, int n) {
            return PixelUtils.NonPretoPre(this.getArgb(byArray, n));
        }

        @Override
        public int getArgb(ByteBuffer byteBuffer, int n) {
            return byteBuffer.get(n) << 24 | byteBuffer.get(n + 1) & 0xFF | (byteBuffer.get(n + 2) & 0xFF) << 8 | (byteBuffer.get(n + 3) & 0xFF) << 16;
        }

        @Override
        public int getArgbPre(ByteBuffer byteBuffer, int n) {
            return PixelUtils.NonPretoPre(this.getArgb(byteBuffer, n));
        }

        @Override
        public void setArgb(byte[] byArray, int n, int n2) {
            byArray[n] = (byte)(n2 >> 24);
            byArray[n + 1] = (byte)n2;
            byArray[n + 2] = (byte)(n2 >> 8);
            byArray[n + 3] = (byte)(n2 >> 16);
        }

        @Override
        public void setArgbPre(byte[] byArray, int n, int n2) {
            this.setArgb(byArray, n, PixelUtils.PretoNonPre(n2));
        }

        @Override
        public void setArgb(ByteBuffer byteBuffer, int n, int n2) {
            byteBuffer.put(n, (byte)(n2 >> 24));
            byteBuffer.put(n + 1, (byte)n2);
            byteBuffer.put(n + 2, (byte)(n2 >> 8));
            byteBuffer.put(n + 3, (byte)(n2 >> 16));
        }

        @Override
        public void setArgbPre(ByteBuffer byteBuffer, int n, int n2) {
            this.setArgb(byteBuffer, n, PixelUtils.PretoNonPre(n2));
        }
    }
}

