/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.media;

import com.sun.javafx.css.media.MediaQuery;
import com.sun.javafx.css.media.MediaQueryContext;
import com.sun.javafx.css.media.expression.FunctionExpression;
import java.util.Locale;
import java.util.function.Function;
import javafx.application.ColorScheme;

final class MediaFeatures {
    private MediaFeatures() {
    }

    public static MediaQuery featureQueryExpression(String string, String string2) {
        string = string.toLowerCase(Locale.ROOT).intern();
        if (string2 != null) {
            string2 = string2.toLowerCase(Locale.ROOT).intern();
        }
        return switch (string) {
            case "prefers-color-scheme" -> new FunctionExpression<ColorScheme>(string, MediaFeatures.checkNotNullValue(string, string2), MediaQueryContext::getColorScheme, MediaFeatures.enumValue(ColorScheme::valueOf, string, string2));
            case "prefers-reduced-motion" -> MediaFeatures.booleanPreferenceExpression(string, string2, "reduce", MediaQueryContext::isReducedMotion);
            case "prefers-reduced-transparency" -> MediaFeatures.booleanPreferenceExpression(string, string2, "reduce", MediaQueryContext::isReducedTransparency);
            case "prefers-reduced-data" -> MediaFeatures.booleanPreferenceExpression(string, string2, "reduce", MediaQueryContext::isReducedData);
            case "-fx-prefers-persistent-scrollbars" -> MediaFeatures.booleanPreferenceExpression(string, string2, "persistent", MediaQueryContext::isPersistentScrollBars);
            default -> throw new IllegalArgumentException(String.format("Unknown media feature <%s>", string));
        };
    }

    private static MediaQuery booleanPreferenceExpression(String string, String string2, String string3, Function<MediaQueryContext, Boolean> function) {
        if ("no-preference".equals(string2)) {
            return new FunctionExpression<Boolean>(string, string2, function, false);
        }
        if (string2 == null || string3.equals(string2)) {
            return new FunctionExpression<Boolean>(string, string2, function, true);
        }
        throw new IllegalArgumentException(String.format("Unknown value <%s> for media feature <%s>", string2, string));
    }

    private static String checkNotNullValue(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException(String.format("Media feature <%s> cannot be evaluated in a boolean context", string));
        }
        return string2;
    }

    private static <T extends Enum<T>> T enumValue(Function<String, T> function, String string, String string2) {
        try {
            return (T)((Enum)function.apply(string2.toUpperCase(Locale.ROOT)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(String.format("Unknown value <%s> for media feature <%s>", string2, string));
        }
    }
}

