/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.jackson.nullable;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class JsonNullable<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final JsonNullable<?> UNDEFINED = new JsonNullable<Object>(null, false);
    private final T value;
    private final boolean isPresent;

    private JsonNullable(T value, boolean isPresent) {
        this.value = value;
        this.isPresent = isPresent;
    }

    public static <T> JsonNullable<T> undefined() {
        JsonNullable<?> t = UNDEFINED;
        return t;
    }

    public static <T> JsonNullable<T> of(T value) {
        return new JsonNullable<T>(value, true);
    }

    public T get() {
        if (!this.isPresent) {
            throw new NoSuchElementException("Value is undefined");
        }
        return this.value;
    }

    public T orElse(T other) {
        return this.isPresent ? this.value : other;
    }

    public T orElseGet(Supplier<? extends T> supplier) {
        return this.isPresent ? this.value : supplier.get();
    }

    public T orElseThrow() {
        if (!this.isPresent) {
            throw new NoSuchElementException("Value is undefined");
        }
        return this.value;
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> supplier) throws X {
        if (this.isPresent) {
            return this.value;
        }
        throw (Throwable)supplier.get();
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public boolean isUndefined() {
        return !this.isPresent;
    }

    public void ifPresent(Consumer<? super T> action) {
        if (this.isPresent) {
            action.accept(this.value);
        }
    }

    public void ifPresentOrElse(Consumer<? super T> action, Runnable undefinedAction) {
        if (this.isPresent) {
            action.accept(this.value);
        } else {
            undefinedAction.run();
        }
    }

    public JsonNullable<T> filter(Predicate<T> predicate) {
        if (predicate == null) {
            throw new NullPointerException("filter predicate is null");
        }
        if (this.isPresent && predicate.test(this.value)) {
            return this;
        }
        return JsonNullable.undefined();
    }

    public <U> JsonNullable<U> map(Function<T, U> mapper) {
        if (mapper == null) {
            throw new NullPointerException("mapping function is null");
        }
        if (this.isPresent) {
            return new JsonNullable<U>(mapper.apply(this.value), true);
        }
        return JsonNullable.undefined();
    }

    public <U> JsonNullable<U> flatMap(Function<? super T, ? extends JsonNullable<? extends U>> mapper) {
        if (mapper == null) {
            throw new NullPointerException("mapping function is null");
        }
        if (!this.isPresent) {
            return JsonNullable.undefined();
        }
        JsonNullable<? extends U> mapped = mapper.apply(this.value);
        if (mapped == null) {
            throw new NullPointerException("mapped value is null");
        }
        return mapped;
    }

    public JsonNullable<T> or(Supplier<? extends JsonNullable<? extends T>> supplier) {
        if (supplier == null) {
            throw new NullPointerException("or supplier is null");
        }
        if (this.isPresent) {
            return this;
        }
        JsonNullable<? extends T> supplied = supplier.get();
        if (supplied == null) {
            throw new NullPointerException("supplied value is null");
        }
        return supplied;
    }

    public Stream<T> stream() {
        if (this.isPresent) {
            return Stream.of(this.value);
        }
        return Stream.empty();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsonNullable)) {
            return false;
        }
        JsonNullable other = (JsonNullable)obj;
        return Objects.equals(this.value, other.value) && this.isPresent == other.isPresent;
    }

    public int hashCode() {
        return Objects.hash(this.value, this.isPresent);
    }

    public String toString() {
        return this.isPresent ? String.format("JsonNullable[%s]", this.value) : "JsonNullable.undefined";
    }
}

