/*
 * (C) Copyright 2011 Nuxeo SA (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     Anahide Tchertchian
 */
package org.nuxeo.theme.styling.service.descriptors;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;

/**
 * @since 5.5
 */
@XObject("palettePreview")
public class PalettePreview {

    @XNodeList(value = "colors/color", type = ArrayList.class, componentType = String.class)
    List<String> colors;

    public List<String> getColors() {
        return colors;
    }

    public void setColors(List<String> colors) {
        this.colors = colors;
    }

    public PalettePreview clone() {
        PalettePreview clone = new PalettePreview();
        if (colors != null) {
            List<String> newColors = new ArrayList<String>();
            newColors.addAll(colors);
            clone.setColors(newColors);
        }
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PalettePreview)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PalettePreview p = (PalettePreview) obj;
        return new EqualsBuilder().append(colors, p.colors).isEquals();
    }

}
