/*
 * (C) Copyright 2015 Nuxeo SA (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-2.1.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     Anahide Tchertchian
 */
package org.nuxeo.theme.styling.service.descriptors;

import java.util.HashMap;
import java.util.Map;

import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.theme.styling.negotiation.Negotiator;

/**
 * Descriptor for contributed negotiators.
 *
 * @since 7.4
 */
@XObject("negotiator")
public class NegotiatorDescriptor implements Comparable<NegotiatorDescriptor> {

    @XNode("@class")
    protected Class<Negotiator> klass;

    @XNode("@order")
    protected int order = 0;

    @XNodeMap(value = "property", key = "@name", type = HashMap.class, componentType = String.class)
    Map<String, String> properties = new HashMap<String, String>();

    public Class<Negotiator> getNegotiatorClass() {
        return klass;
    }

    public void setNegotiatorKlass(Class<Negotiator> klass) {
        this.klass = klass;
    }

    public int getOrder() {
        return order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public Map<String, String> getProperties() {
        return properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    public int compareTo(NegotiatorDescriptor o) {
        int cmp = order - o.order;
        if (cmp == 0) {
            // make sure we have a deterministic sort
            cmp = klass.getName().compareTo(o.klass.getName());
        }
        return cmp;
    }

    @Override
    public NegotiatorDescriptor clone() {
        NegotiatorDescriptor clone = new NegotiatorDescriptor();
        clone.setNegotiatorKlass(getNegotiatorClass());
        clone.setOrder(getOrder());
        Map<String, String> props = getProperties();
        if (props != null) {
            clone.setProperties(new HashMap<String, String>(props));
        }
        return clone;
    }

}
