/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.html.filters.layout;

import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.theme.formats.Format;
import org.nuxeo.theme.rendering.RenderingInfo;
import org.nuxeo.theme.views.AbstractView;

public class DefaultLayoutView
extends AbstractView {
    static final Pattern firstTagPattern = Pattern.compile("<(.*?)>", 32);
    static final Pattern otherTagsPattern = Pattern.compile("<.*?>(.*)", 32);
    static final Pattern styleAttrPattern = Pattern.compile(" style=\"(.*?)\"", 32);

    public String render(RenderingInfo info) {
        String markup = info.getMarkup();
        Format format = info.getFormat();
        if (!format.hasProperties()) {
            return markup;
        }
        Matcher firstMatcher = firstTagPattern.matcher(markup);
        Matcher othersMatcher = otherTagsPattern.matcher(markup);
        if (!firstMatcher.find() || !othersMatcher.find()) {
            return markup;
        }
        String inBrackets = firstMatcher.group(1);
        Matcher styleAttrMatcher = styleAttrPattern.matcher(inBrackets);
        StringBuilder styleAttributes = new StringBuilder();
        if (styleAttrMatcher.find()) {
            styleAttributes.append(styleAttrMatcher.group(1));
            if (!styleAttributes.toString().endsWith(";")) {
                styleAttributes.append(';');
            }
        }
        Enumeration propertyNames = format.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            styleAttributes.append(propertyName);
            styleAttributes.append(':');
            styleAttributes.append(format.getProperty(propertyName));
            styleAttributes.append(';');
        }
        if (styleAttributes.length() == 0) {
            return markup;
        }
        if ((inBrackets = inBrackets.replaceAll(styleAttrPattern.toString(), "")).endsWith("/")) {
            return String.format("<%s style=\"%s\" />%s", inBrackets.replaceAll("/$", "").trim(), styleAttributes.toString(), othersMatcher.group(1));
        }
        return String.format("<%s style=\"%s\">%s", inBrackets, styleAttributes.toString(), othersMatcher.group(1));
    }
}

