/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class LoginModuleWrapper
implements LoginModule {
    public static final String DELEGATE_CLASS_KEY = LoginModuleWrapper.class.getName() + ".delegate";
    protected LoginModule delegate;

    protected void initDelegate(Map<String, ?> options) {
        if (this.delegate == null) {
            try {
                Class clazz = (Class)options.get(DELEGATE_CLASS_KEY);
                this.delegate = (LoginModule)clazz.newInstance();
            }
            catch (NullPointerException e) {
                throw new RuntimeException("Should be a bug: No DELEGATE_CLASS_KEY found in login module options", e);
            }
            catch (ClassCastException e) {
                throw new RuntimeException("Invalid login module class: " + options.get(DELEGATE_CLASS_KEY) + ". Should implement LoginModule.", e);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot instantiate login module: " + options.get(DELEGATE_CLASS_KEY), e);
            }
        }
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.initDelegate(options);
        this.delegate.initialize(subject, callbackHandler, sharedState, options);
    }

    @Override
    public boolean login() throws LoginException {
        return this.delegate.login();
    }

    @Override
    public boolean commit() throws LoginException {
        return this.delegate.commit();
    }

    @Override
    public boolean abort() throws LoginException {
        return this.delegate.abort();
    }

    @Override
    public boolean logout() throws LoginException {
        return this.delegate.logout();
    }
}

