/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import java.util.HashSet;
import java.util.Set;

public abstract class TargetExtensions {
    protected Set<String> targetExtensions = new HashSet<String>();

    protected TargetExtensions() {
        this.initialize();
    }

    public Set<String> getTargetExtensions() {
        return this.targetExtensions;
    }

    public void addTargetExtension(String name, String extension) {
        this.targetExtensions.add(TargetExtensions.newTargetExtension(name, extension));
    }

    public static String newTargetExtension(String name, String extension) {
        return String.format("%s:%s", name, extension);
    }

    protected abstract void initialize();

    public static class Automation
    extends ContentModel {
        @Override
        protected void initialize() {
            super.initialize();
            this.addTargetExtension("org.nuxeo.ecm.core.operation.OperationServiceComponent", "event-handlers");
            this.addTargetExtension("org.nuxeo.ecm.core.operation.OperationServiceComponent", "chains");
            this.addTargetExtension("org.nuxeo.automation.scripting.internals.AutomationScriptingComponent", "operation");
        }
    }

    public static class ContentTemplate
    extends ContentModel {
        @Override
        protected void initialize() {
            super.initialize();
            this.addTargetExtension("org.nuxeo.ecm.platform.content.template.service.ContentTemplateService", "factoryBinding");
        }
    }

    public static class ContentModel
    extends TargetExtensions {
        @Override
        protected void initialize() {
            this.addTargetExtension("org.nuxeo.ecm.core.schema.TypeService", "schema");
            this.addTargetExtension("org.nuxeo.ecm.core.schema.TypeService", "doctype");
            this.addTargetExtension("org.nuxeo.ecm.core.lifecycle.LifeCycleService", "types");
            this.addTargetExtension("org.nuxeo.ecm.core.lifecycle.LifeCycleService", "lifecycle");
            this.addTargetExtension("org.nuxeo.ecm.directory.sql.SQLDirectoryFactory", "directories");
            this.addTargetExtension("org.nuxeo.ecm.core.versioning.VersioningService", "versioningRules");
        }
    }
}

