/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.codec;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.runtime.codec.CodecDescriptor;
import org.nuxeo.runtime.codec.CodecFactory;
import org.nuxeo.runtime.codec.CodecService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class CodecServiceImpl
extends DefaultComponent
implements CodecService {
    private static final Log log = LogFactory.getLog(CodecServiceImpl.class);
    public static final String CODEC_XP = "codec";
    public static final int APPLICATION_STARTED_ORDER = -600;
    protected final Map<String, CodecDescriptor> configs = new HashMap<String, CodecDescriptor>();
    protected final Map<String, CodecFactory> codecFactories = new HashMap<String, CodecFactory>();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(CODEC_XP)) {
            CodecDescriptor descriptor = (CodecDescriptor)contribution;
            this.configs.put(descriptor.getName(), descriptor);
            log.debug((Object)String.format("Register Codec contribution: %s", descriptor));
            this.codecFactories.put(descriptor.getName(), descriptor.getInstance());
        }
    }

    public int getApplicationStartedOrder() {
        return -600;
    }

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
        log.debug((Object)"Deactivating service");
    }

    public void activate(ComponentContext context) {
        super.activate(context);
        log.debug((Object)"Activating service");
    }

    @Override
    public <T> Codec<T> getCodec(String codecName, Class<T> objectClass) {
        if (!this.codecFactories.containsKey(codecName)) {
            return null;
        }
        return this.codecFactories.get(codecName).newCodec(objectClass);
    }
}

