/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.codec;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.codec.CodecFactory;

@XObject(value="codec")
public class CodecDescriptor {
    @XNode(value="@name")
    protected String name;
    @XNode(value="@class")
    protected Class<CodecFactory> klass;
    @XNodeMap(value="option", key="@name", type=HashMap.class, componentType=String.class)
    public Map<String, String> options = new HashMap<String, String>();

    public String getName() {
        return this.name;
    }

    public Class<CodecFactory> getKlass() {
        return this.klass;
    }

    public String toString() {
        return "CodecDescriptor{klass=" + this.klass + ", options=" + this.options + '}';
    }

    public CodecFactory getInstance() {
        try {
            CodecFactory ret = this.getKlass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ret.init(this.options);
            return ret;
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Invalid class: " + this.getClass(), e);
        }
    }
}

