/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.codec;

import java.util.Map;
import org.apache.avro.message.SchemaStore;
import org.nuxeo.lib.stream.codec.AvroBinaryCodec;
import org.nuxeo.lib.stream.codec.AvroJsonCodec;
import org.nuxeo.lib.stream.codec.AvroMessageCodec;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.avro.AvroService;
import org.nuxeo.runtime.codec.CodecFactory;

public class AvroCodecFactory
implements CodecFactory {
    protected String encoding;

    @Override
    public void init(Map<String, String> options) {
        this.encoding = options.getOrDefault("encoding", "default");
    }

    @Override
    public <T> Codec<T> newCodec(Class<T> objectClass) {
        switch (this.encoding) {
            case "json": {
                return new AvroJsonCodec(objectClass);
            }
            case "binary": {
                return new AvroBinaryCodec(objectClass);
            }
        }
        return new AvroMessageCodec(objectClass, (SchemaStore)Framework.getService(AvroService.class));
    }
}

