/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.avro;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.avro.Schema;
import org.nuxeo.runtime.avro.AvroSchemaFactory;
import org.nuxeo.runtime.avro.AvroService;

public class AvroSchemaFactoryContext {
    protected static final AvroSchemaFactory<Object> NULL = new AvroSchemaFactory<Object>(null){

        @Override
        public Schema createSchema(Object input) {
            return null;
        }

        @Override
        public String getName(Object input) {
            return null;
        }
    };
    protected final Map<Class<?>, AvroSchemaFactory<?>> factories = new HashMap();
    protected final Map<String, Schema> createdSchemas = new HashMap<String, Schema>();
    protected final AvroService service;

    protected AvroSchemaFactoryContext(AvroService service) {
        this.service = service;
    }

    public <T> Schema createSchema(T input) {
        String qualifiedName = this.getFactory(input).getQualifiedName(input);
        return this.createdSchemas.computeIfAbsent(qualifiedName, k -> this.getFactory(input).createSchema(input));
    }

    public AvroService getService() {
        return this.service;
    }

    public <U> List<U> sort(Collection<U> children) {
        if (children == null || children.isEmpty()) {
            return Collections.emptyList();
        }
        AvroSchemaFactory factory = this.getFactory(children.iterator().next());
        if (factory == null) {
            return Collections.emptyList();
        }
        ArrayList<U> sortedChildren = new ArrayList<U>(children);
        sortedChildren.sort((o1, o2) -> Objects.compare(factory.getQualifiedName(o1), factory.getQualifiedName(o2), String::compareTo));
        return sortedChildren;
    }

    protected <T> AvroSchemaFactory<T> getFactory(T input) {
        AvroSchemaFactory<?> factory = this.factories.get(input.getClass());
        if (factory != null) {
            return factory;
        }
        for (Class<?> intrface : input.getClass().getInterfaces()) {
            factory = this.factories.get(intrface);
            if (factory == null) continue;
            return factory;
        }
        for (Map.Entry entry : this.factories.entrySet()) {
            if (!((Class)entry.getKey()).isAssignableFrom(input.getClass())) continue;
            return (AvroSchemaFactory)entry.getValue();
        }
        return NULL;
    }

    protected void register(Class<?> type, AvroSchemaFactory<?> factory) {
        this.factories.put(type, factory);
    }
}

