/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.avro;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import org.apache.avro.Schema;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.avro.AvroMapper;
import org.nuxeo.runtime.avro.AvroMapperDescriptor;
import org.nuxeo.runtime.avro.AvroReplacementDescriptor;
import org.nuxeo.runtime.avro.AvroSchemaDescriptor;
import org.nuxeo.runtime.avro.AvroSchemaFactoryDescriptor;
import org.nuxeo.runtime.avro.AvroService;
import org.nuxeo.runtime.avro.AvroServiceImpl;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.SimpleContributionRegistry;

public class AvroComponent
extends DefaultComponent {
    public static final int APPLICATION_START_ORDER = -600;
    public static final String SCHEMA_XP = "schema";
    public static final String MAPPER_XP = "mapper";
    public static final String FACTORY_XP = "factory";
    public static final String REPLACEMENT_XP = "replacement";
    protected final AvroMapperDescriptorRegistry avroMapperDescriptors = new AvroMapperDescriptorRegistry();
    protected final AvroSchemaDescriptorRegistry schemaDescriptors = new AvroSchemaDescriptorRegistry();
    protected final AvroSchemaFactoryDescriptorRegistry avroSchemaFactoryDescriptors = new AvroSchemaFactoryDescriptorRegistry();
    protected final AvroReplacementDescriptorRegistry replacementDescriptors = new AvroReplacementDescriptorRegistry();
    protected AvroService avroService;

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(this.avroService.getClass())) {
            return (T)this.avroService;
        }
        return null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        switch (extensionPoint) {
            case "schema": {
                this.schemaDescriptors.addContribution((AvroSchemaDescriptor)contribution);
                break;
            }
            case "mapper": {
                this.avroMapperDescriptors.addContribution((AvroMapperDescriptor)contribution);
                break;
            }
            case "factory": {
                this.avroSchemaFactoryDescriptors.addContribution((AvroSchemaFactoryDescriptor)contribution);
                break;
            }
            case "replacement": {
                this.replacementDescriptors.addContribution((AvroReplacementDescriptor)contribution);
                break;
            }
            default: {
                throw new RuntimeServiceException("Unknown extension point: " + extensionPoint);
            }
        }
    }

    public int getApplicationStartedOrder() {
        return -600;
    }

    public void start(ComponentContext context) {
        Collection<AvroSchemaFactoryDescriptor> factoryDescriptors = this.avroSchemaFactoryDescriptors.getDescriptors();
        HashMap factories = new HashMap(factoryDescriptors.size());
        for (AvroSchemaFactoryDescriptor descriptor : factoryDescriptors) {
            try {
                Class<?> type = Class.forName(descriptor.type);
                factories.put(type, Class.forName(descriptor.clazz));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeServiceException((Throwable)e);
            }
        }
        AvroServiceImpl impl = new AvroServiceImpl(this.replacementDescriptors.getDescriptors(), factories);
        Collection<AvroMapperDescriptor> mapperDescriptors = this.avroMapperDescriptors.getDescriptors();
        HashMap mappers = new HashMap(mapperDescriptors.size());
        for (AvroMapperDescriptor avroMapperDescriptor : mapperDescriptors) {
            try {
                Class<?> type = Class.forName(avroMapperDescriptor.type);
                Class<?> clazz = Class.forName(avroMapperDescriptor.clazz);
                Constructor<?> constructor = clazz.getConstructor(AvroService.class);
                mappers.put(type, (AvroMapper<?, ?>)constructor.newInstance(impl));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeServiceException((Throwable)e);
            }
        }
        impl.setMappers(mappers);
        for (AvroSchemaDescriptor avroSchemaDescriptor : this.schemaDescriptors.getDescriptors()) {
            URL url = context.getRuntimeContext().getResource(avroSchemaDescriptor.file);
            try {
                InputStream stream = url == null ? null : url.openStream();
                Throwable throwable = null;
                try {
                    if (stream == null) {
                        throw new RuntimeServiceException("Could not load stream for file " + avroSchemaDescriptor.file);
                    }
                    impl.addSchema(new Schema.Parser().parse(stream));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeServiceException((Throwable)e);
            }
        }
        this.avroService = impl;
    }

    public void stop(ComponentContext context) {
        this.avroService = null;
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        switch (extensionPoint) {
            case "schema": {
                this.schemaDescriptors.removeContribution((AvroSchemaDescriptor)contribution);
                break;
            }
            case "mapper": {
                this.avroMapperDescriptors.removeContribution((AvroMapperDescriptor)contribution);
                break;
            }
            case "factory": {
                this.avroSchemaFactoryDescriptors.removeContribution((AvroSchemaFactoryDescriptor)contribution);
                break;
            }
            case "replacement": {
                this.replacementDescriptors.removeContribution((AvroReplacementDescriptor)contribution);
                break;
            }
            default: {
                throw new RuntimeServiceException("Unknown extension point: " + extensionPoint);
            }
        }
    }

    protected static class AvroSchemaFactoryDescriptorRegistry
    extends SimpleContributionRegistry<AvroSchemaFactoryDescriptor> {
        protected AvroSchemaFactoryDescriptorRegistry() {
        }

        public String getContributionId(AvroSchemaFactoryDescriptor contrib) {
            return contrib.type;
        }

        public Collection<AvroSchemaFactoryDescriptor> getDescriptors() {
            return this.currentContribs.values();
        }
    }

    protected static class AvroSchemaDescriptorRegistry
    extends SimpleContributionRegistry<AvroSchemaDescriptor> {
        protected AvroSchemaDescriptorRegistry() {
        }

        public String getContributionId(AvroSchemaDescriptor contrib) {
            return contrib.name;
        }

        public Collection<AvroSchemaDescriptor> getDescriptors() {
            return this.currentContribs.values();
        }
    }

    protected static class AvroReplacementDescriptorRegistry
    extends SimpleContributionRegistry<AvroReplacementDescriptor> {
        protected AvroReplacementDescriptorRegistry() {
        }

        public String getContributionId(AvroReplacementDescriptor contrib) {
            return contrib.forbidden;
        }

        public Collection<AvroReplacementDescriptor> getDescriptors() {
            return this.currentContribs.values();
        }
    }

    protected static class AvroMapperDescriptorRegistry
    extends SimpleContributionRegistry<AvroMapperDescriptor> {
        protected AvroMapperDescriptorRegistry() {
        }

        public String getContributionId(AvroMapperDescriptor contrib) {
            return contrib.type;
        }

        public Collection<AvroMapperDescriptor> getDescriptors() {
            return this.currentContribs.values();
        }
    }
}

