/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.stream;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.lib.stream.StreamRuntimeException;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.computation.Settings;
import org.nuxeo.lib.stream.computation.StreamProcessor;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.lib.stream.computation.log.LogStreamProcessor;
import org.nuxeo.lib.stream.log.chronicle.ChronicleLogManager;
import org.nuxeo.lib.stream.log.kafka.KafkaLogManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.codec.CodecService;
import org.nuxeo.runtime.kafka.KafkaConfigService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.stream.LogConfigDescriptor;
import org.nuxeo.runtime.stream.StreamProcessorDescriptor;
import org.nuxeo.runtime.stream.StreamService;

public class StreamServiceImpl
extends DefaultComponent
implements StreamService {
    private static final Logger log = LogManager.getLogger(StreamServiceImpl.class);
    public static final String NUXEO_STREAM_DIR_PROP = "nuxeo.stream.chronicle.dir";
    public static final String NUXEO_STREAM_RET_DURATION_PROP = "nuxeo.stream.chronicle.retention.duration";
    public static final String DEFAULT_CODEC = "avro";
    protected static final String XP_LOG_CONFIG = "logConfig";
    protected static final String XP_STREAM_PROCESSOR = "streamProcessor";
    protected final Map<String, org.nuxeo.lib.stream.log.LogManager> managers = new HashMap<String, org.nuxeo.lib.stream.log.LogManager>();
    protected final Map<String, StreamProcessor> processors = new HashMap<String, StreamProcessor>();

    public int getApplicationStartedOrder() {
        return -590;
    }

    @Override
    public org.nuxeo.lib.stream.log.LogManager getLogManager(String name) {
        if (!this.managers.containsKey(name)) {
            LogConfigDescriptor config = (LogConfigDescriptor)this.getDescriptor(XP_LOG_CONFIG, name);
            if (config == null) {
                throw new IllegalArgumentException("Unknown logConfig: " + name);
            }
            if ("kafka".equalsIgnoreCase(config.type)) {
                this.managers.put(name, this.createKafkaLogManager(config));
            } else {
                this.managers.put(name, this.createChronicleLogManager(config));
            }
        }
        return this.managers.get(name);
    }

    protected org.nuxeo.lib.stream.log.LogManager createKafkaLogManager(LogConfigDescriptor config) {
        String kafkaConfig = config.options.getOrDefault("kafkaConfig", "default");
        KafkaConfigService service = (KafkaConfigService)Framework.getService(KafkaConfigService.class);
        return new KafkaLogManager(service.getTopicPrefix(kafkaConfig), service.getProducerProperties(kafkaConfig), service.getConsumerProperties(kafkaConfig));
    }

    protected org.nuxeo.lib.stream.log.LogManager createChronicleLogManager(LogConfigDescriptor config) {
        String basePath = config.options.getOrDefault("basePath", null);
        String directory = config.options.getOrDefault("directory", config.getId());
        Path path = this.getChroniclePath(basePath, directory);
        String retention = this.getChronicleRetention(config.options.getOrDefault("retention", null));
        return new ChronicleLogManager(path, retention);
    }

    protected String getChronicleRetention(String retention) {
        return retention != null ? retention : Framework.getProperty((String)NUXEO_STREAM_RET_DURATION_PROP, (String)"4d");
    }

    protected Path getChroniclePath(String basePath, String name) {
        if (basePath != null) {
            return Paths.get(basePath, name).toAbsolutePath();
        }
        basePath = Framework.getProperty((String)NUXEO_STREAM_DIR_PROP);
        if (basePath != null) {
            return Paths.get(basePath, name).toAbsolutePath();
        }
        basePath = Framework.getProperty((String)"nuxeo.data.dir");
        if (basePath != null) {
            return Paths.get(basePath, "stream", name).toAbsolutePath();
        }
        return Paths.get(Framework.getRuntime().getHome().getAbsolutePath(), "data", "stream", name).toAbsolutePath();
    }

    protected void createStreamIfNotExists(LogConfigDescriptor config) {
        if (config.logs.isEmpty()) {
            return;
        }
        org.nuxeo.lib.stream.log.LogManager manager = this.getLogManager(config.getId());
        config.logs.forEach(l -> {
            log.info("Create if not exists stream: {} with manager: {}", (Object)l.getId(), (Object)config.getId());
            manager.createIfNotExists(l.getId(), l.size.intValue());
        });
    }

    public void start(ComponentContext context) {
        super.start(context);
        List logDescs = this.getDescriptors(XP_LOG_CONFIG);
        logDescs.forEach(this::createStreamIfNotExists);
        List streamDescs = this.getDescriptors(XP_STREAM_PROCESSOR);
        streamDescs.forEach(this::initProcessor);
        new ComponentsLifeCycleListener().install();
    }

    protected void initProcessor(StreamProcessorDescriptor descriptor) {
        Topology topology;
        if (this.processors.containsKey(descriptor.getId())) {
            log.error("Processor already initialized: {}", (Object)descriptor.getId());
            return;
        }
        log.info("Init Stream processor: {} with manager: {}", (Object)descriptor.getId(), (Object)descriptor.config);
        org.nuxeo.lib.stream.log.LogManager manager = this.getLogManager(descriptor.config);
        try {
            topology = descriptor.klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).getTopology(descriptor.options);
        }
        catch (ReflectiveOperationException e) {
            throw new StreamRuntimeException("Can not create topology for processor: " + descriptor.getId(), (Throwable)e);
        }
        LogStreamProcessor streamProcessor = new LogStreamProcessor(manager);
        Settings settings = this.getSettings(descriptor);
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = descriptor::getId;
        supplierArray[1] = () -> topology.toPlantuml(settings);
        log.debug("Starting computation topology: {}\n{}", supplierArray);
        streamProcessor.init(topology, settings);
        this.processors.put(descriptor.getId(), (StreamProcessor)streamProcessor);
    }

    protected Settings getSettings(StreamProcessorDescriptor descriptor) {
        CodecService codecService = (CodecService)Framework.getService(CodecService.class);
        Codec<Record> actualCodec = descriptor.defaultCodec == null ? codecService.getCodec(DEFAULT_CODEC, Record.class) : codecService.getCodec(descriptor.defaultCodec, Record.class);
        Settings settings = new Settings(descriptor.defaultConcurrency.intValue(), descriptor.defaultPartitions.intValue(), actualCodec, descriptor.getDefaultPolicy());
        descriptor.computations.forEach(comp -> settings.setConcurrency(comp.name, comp.concurrency.intValue()));
        descriptor.policies.forEach(policy -> settings.setPolicy(policy.name, descriptor.getPolicy(policy.name)));
        descriptor.streams.forEach(stream -> settings.setPartitions(stream.name, stream.partitions.intValue()));
        descriptor.streams.stream().filter(stream -> Objects.nonNull(stream.codec)).forEach(stream -> settings.setCodec(stream.name, codecService.getCodec(stream.codec, Record.class)));
        return settings;
    }

    public void stop(ComponentContext context) throws InterruptedException {
        super.stop(context);
        this.stopComputations();
        this.closeLogManagers();
    }

    protected void startComputations() {
        this.getDescriptors(XP_STREAM_PROCESSOR).forEach(d -> {
            StreamProcessor manager = this.processors.get(d.getId());
            if (manager != null) {
                manager.start();
            }
        });
    }

    protected void stopComputations() {
        this.processors.forEach((name, manager) -> manager.stop(Duration.ofSeconds(1L)));
        this.processors.clear();
    }

    protected void closeLogManagers() {
        this.managers.values().stream().filter(Objects::nonNull).forEach(org.nuxeo.lib.stream.log.LogManager::close);
        this.managers.clear();
    }

    protected class ComponentsLifeCycleListener
    implements ComponentManager.Listener {
        protected ComponentsLifeCycleListener() {
        }

        public void afterStart(ComponentManager mgr, boolean isResume) {
            StreamServiceImpl.this.startComputations();
        }

        public void beforeStop(ComponentManager mgr, boolean isStandby) {
            StreamServiceImpl.this.stopComputations();
            Framework.getRuntime().getComponentManager().removeListener((ComponentManager.Listener)this);
        }
    }
}

