/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.stream;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.RetryPolicy;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.lib.stream.StreamRuntimeException;
import org.nuxeo.lib.stream.computation.ComputationPolicy;
import org.nuxeo.lib.stream.computation.ComputationPolicyBuilder;
import org.nuxeo.runtime.model.Descriptor;
import org.nuxeo.runtime.stream.StreamComputationPolicy;
import org.nuxeo.runtime.stream.StreamProcessorTopology;

@XObject(value="streamProcessor")
public class StreamProcessorDescriptor
implements Descriptor {
    public static final Integer DEFAULT_CONCURRENCY = 4;
    @XNode(value="@name")
    public String name;
    @XNode(value="@logConfig")
    public String config;
    @XNode(value="@class")
    public Class<? extends StreamProcessorTopology> klass;
    @XNode(value="@defaultConcurrency")
    public Integer defaultConcurrency = DEFAULT_CONCURRENCY;
    @XNode(value="@defaultPartitions")
    public Integer defaultPartitions = DEFAULT_CONCURRENCY;
    @XNode(value="@defaultCodec")
    public String defaultCodec;
    @XNodeMap(value="option", key="@name", type=HashMap.class, componentType=String.class)
    public Map<String, String> options = new HashMap<String, String>();
    @XNodeList(value="computation", type=ArrayList.class, componentType=ComputationDescriptor.class)
    public List<ComputationDescriptor> computations = new ArrayList<ComputationDescriptor>();
    @XNodeList(value="stream", type=ArrayList.class, componentType=StreamDescriptor.class)
    public List<StreamDescriptor> streams = new ArrayList<StreamDescriptor>();
    @XNodeList(value="policy", type=ArrayList.class, componentType=PolicyDescriptor.class)
    public List<PolicyDescriptor> policies = new ArrayList<PolicyDescriptor>();
    protected ComputationPolicy defaultPolicy;

    public ComputationPolicy getPolicy(String computationName) {
        PolicyDescriptor policyDescriptor = this.policies.stream().filter(policy -> computationName.equals(policy.getId())).findFirst().orElse(null);
        if (policyDescriptor != null) {
            return this.getComputationPolicy(policyDescriptor);
        }
        return null;
    }

    protected ComputationPolicy getComputationPolicy(PolicyDescriptor policyDescriptor) {
        if (policyDescriptor.klass != null) {
            if (!StreamComputationPolicy.class.isAssignableFrom(policyDescriptor.klass)) {
                throw new IllegalArgumentException("Cannot create policy: " + policyDescriptor.getId() + " for processor: " + this.getId() + ", class must implement StreamComputationPolicy");
            }
            try {
                return policyDescriptor.klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).getPolicy(policyDescriptor);
            }
            catch (ReflectiveOperationException e) {
                throw new StreamRuntimeException("Cannot create policy: " + policyDescriptor.getId() + " for processor: " + this.getId(), (Throwable)e);
            }
        }
        RetryPolicy retryPolicy = new RetryPolicy().withMaxRetries(policyDescriptor.maxRetries.intValue()).withBackoff(policyDescriptor.delay.toMillis(), policyDescriptor.maxDelay.toMillis(), TimeUnit.MILLISECONDS);
        return new ComputationPolicyBuilder().retryPolicy(retryPolicy).batchPolicy(policyDescriptor.batchCapacity.intValue(), policyDescriptor.batchThreshold).continueOnFailure(policyDescriptor.continueOnFailure.booleanValue()).build();
    }

    public ComputationPolicy getDefaultPolicy() {
        if (this.defaultPolicy == null) {
            PolicyDescriptor policyDescriptor = this.policies.stream().filter(policy -> "default".equals(policy.getId())).findFirst().orElse(null);
            this.defaultPolicy = policyDescriptor == null ? ComputationPolicy.NONE : this.getComputationPolicy(policyDescriptor);
        }
        return this.defaultPolicy;
    }

    public String getId() {
        return this.name;
    }

    @XObject(value="policy")
    public static class PolicyDescriptor
    implements Descriptor {
        public static final int DEFAULT_MAX_RETRIES = 0;
        public static final Duration DEFAULT_DELAY = Duration.ofSeconds(1L);
        public static final Duration DEFAULT_MAX_DELAY = Duration.ofSeconds(10L);
        public static final Integer DEFAULT_BATCH_CAPACITY = 1;
        public static final Duration DEFAULT_BATCH_THRESHOLD = Duration.ofSeconds(1L);
        @XNode(value="@name")
        public String name;
        @XNode(value="@maxRetries")
        public Integer maxRetries = 0;
        @XNode(value="@delay")
        public Duration delay = DEFAULT_DELAY;
        @XNode(value="@maxDelay")
        public Duration maxDelay = DEFAULT_MAX_DELAY;
        @XNode(value="@continueOnFailure")
        public Boolean continueOnFailure = Boolean.FALSE;
        @XNode(value="@class")
        public Class<? extends StreamComputationPolicy> klass;
        @XNode(value="@batchCapacity")
        public Integer batchCapacity = DEFAULT_BATCH_CAPACITY;
        @XNode(value="@batchThreshold")
        public Duration batchThreshold = DEFAULT_BATCH_THRESHOLD;

        public String getId() {
            return this.name;
        }
    }

    @XObject(value="stream")
    public static class StreamDescriptor
    implements Descriptor {
        @XNode(value="@name")
        public String name;
        @XNode(value="@partitions")
        public Integer partitions = DEFAULT_CONCURRENCY;
        @XNode(value="@codec")
        public String codec;

        public String getId() {
            return this.name;
        }
    }

    @XObject(value="computation")
    public static class ComputationDescriptor
    implements Descriptor {
        @XNode(value="@name")
        public String name;
        @XNode(value="@concurrency")
        public Integer concurrency = DEFAULT_CONCURRENCY;

        public String getId() {
            return this.name;
        }
    }
}

