/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis;

import java.util.HashSet;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import org.nuxeo.ecm.core.redis.RedisFailoverExecutor;
import org.nuxeo.ecm.core.redis.RedisPoolDescriptor;
import org.nuxeo.ecm.core.redis.RedisPoolExecutor;
import org.nuxeo.runtime.model.Descriptor;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.util.Pool;

@XObject(value="sentinel")
public class RedisSentinelDescriptor
extends RedisPoolDescriptor {
    @XNodeList(value="host", type=RedisHostDescriptor[].class, componentType=RedisHostDescriptor.class)
    public RedisHostDescriptor[] hosts = new RedisHostDescriptor[0];
    @XNode(value="master")
    public String master = "master";
    @XNode(value="failoverTimeout")
    public int failoverTimeout = 300;

    @Override
    public RedisExecutor newExecutor() throws RuntimeException {
        HashSet<String> sentinels = new HashSet<String>();
        for (RedisHostDescriptor host : this.hosts) {
            sentinels.add(host.name + ":" + host.port);
        }
        JedisPoolConfig cfg = new JedisPoolConfig();
        JedisSentinelPool sentinel = new JedisSentinelPool(this.master, sentinels, (GenericObjectPoolConfig)cfg, this.timeout, this.password, this.database);
        RedisPoolExecutor base = new RedisPoolExecutor((Pool<Jedis>)sentinel);
        return new RedisFailoverExecutor(this.failoverTimeout, base);
    }

    @XObject(value="host")
    public static class RedisHostDescriptor
    implements Descriptor {
        @XNode(value="@name")
        public String name;
        @XNode(value="@port")
        public int port;

        public RedisHostDescriptor() {
        }

        protected RedisHostDescriptor(String name, int port) {
            this.name = name;
            this.port = port;
        }

        public String getId() {
            return this.name;
        }
    }
}

