/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package org.apache.directory.server.kerberos.shared.messages.value;


/**
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 * @version $Rev: 540371 $, $Date: 2007-05-21 20:00:43 -0400 (Mon, 21 May 2007) $
 */
public class AuthorizationDataEntry
{
    private AuthorizationType authorizationDataType;
    private byte[] authorizationData;


    /**
     * Creates a new instance of AuthorizationDataEntry.
     *
     * @param adType
     * @param adData
     */
    public AuthorizationDataEntry( AuthorizationType adType, byte[] adData )
    {
        authorizationDataType = adType;
        authorizationData = adData;
    }


    /**
     * Returns the raw bytes of the authorization data.
     *
     * @return The raw bytes of the authorization data.
     */
    public byte[] getAuthorizationData()
    {
        return authorizationData;
    }


    /**
     * Returns the {@link AuthorizationType}.
     *
     * @return The {@link AuthorizationType}.
     */
    public AuthorizationType getAuthorizationDataType()
    {
        return authorizationDataType;
    }
}
