/*
 * (C) Copyright 2007 Nuxeo SAS (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     Nuxeo - initial API and implementation
 *
 * $Id$
 */

package org.nuxeo.ecm.platform.picture.api;

/**
 * @author Max Stepanov
 * @author Catalin Baican
 */
public class MetadataConstants {

    public static final String META_WIDTH = "width";

    public static final String META_HEIGHT = "height";

    /* EXIF */
    public static final String META_DESCRIPTION = "description";

    public static final String META_COMMENT = "comment";

    public static final String META_EQUIPMENT = "equipment";

    public static final String META_ORIGINALDATE = "originalDate";

    public static final String META_HRESOLUTION = "horizontalResolution";

    public static final String META_VRESOLUTION = "verticalResolution";

    public static final String META_PIXEL_XDIMENSION = "pixelXDimension";

    public static final String META_PIXEL_YDIMENSION = "pixelYDimension";

    public static final String META_COPYRIGHT = "copyright";

    public static final String META_EXPOSURE = "exposure";

    public static final String META_ISOSPEED = "ISOspeed";

    public static final String META_FOCALLENGTH = "focalLength";

    public static final String META_COLORSPACE = "colorSpace";

    public static final String META_WHITEBALANCE = "whiteBalance";

    public static final String META_ICCPROFILE = "iccProfile";

    public static final String META_ORIENTATION = "orientation";

    public static final String META_FNUMBER = "fNumber";

    /* IPTC */
    public static final String META_BY_LINE = "byLine";

    public static final String META_BY_LINE_TITLE = "byLineTitle";

    public static final String META_CAPTION = "caption";

    public static final String META_CATEGORY = "category";

    public static final String META_CITY = "city";

    public static final String META_COPYRIGHT_NOTICE = "copyrightNotice";

    public static final String META_COUNTRY_OR_PRIMARY_LOCATION = "countryOrPrimaryLocation";

    public static final String META_CREDIT = "credit";

    public static final String META_DATE_CREATED = "dateCreated";

    public static final String META_HEADLINE = "headline";

    public static final String META_KEYWORDS = "keywords";

    public static final String META_LANGUAGE = "language";

    public static final String META_OBJECT_NAME = "objectName";

    public static final String META_ORIGINAL_TRANSMISSION_REFERENCE = "originalTransmissionReference";

    public static final String META_ORIGINATING_PROGRAM = "originatingProgram";

    public static final String META_PROVINCE_OR_STATE = "provinceOrState";

    public static final String META_RECORD_VERSION = "recordVersion";

    public static final String META_RELEASE_DATE = "releaseDate";

    public static final String META_RELEASE_TIME = "releaseTime";

    public static final String META_SOURCE = "source";

    public static final String META_SPECIAL_INSTRUCTIONS = "specialInstructions";

    public static final String META_SUPPLEMENTAL_CATEGORIES = "supplementalCategories";

    public static final String META_TIME_CREATED = "timeCreated";

    public static final String META_URGENCY = "urgency";

    public static final String META_WRITER = "writer";

    private MetadataConstants() {
    }

}
